/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Chunk;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Chunk Coordinates")
@Description(value={"Represents the coordinates of a chunk."})
@Examples(value={"set {_x} to chunk x of chunk at player"})
@Since(value={"1.13.0"})
public class ExprChunkCoords
extends PropertyExpression<Chunk, Number> {
    private boolean x;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.x = parseResult.hasTag("x");
        this.setExpr(exprs[0]);
        return true;
    }

    protected Number @NotNull [] get(Event event, Chunk[] source) {
        return (Number[])this.get(source, chunk -> this.x ? chunk.getX() : chunk.getZ());
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String x = this.x ? "x" : "z";
        return "chunk " + x + " coord of " + this.getExpr().toString(e, d);
    }

    static {
        Skript.registerExpression(ExprChunkCoords.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"chunk (:x|z) of %chunk%"});
    }
}

