/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.elements.other.type.Types;
import org.bukkit.Chunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Chunk Load Level")
@Description(value={"Get the load level of a chunk. See type for description of levels. Requires Minecraft 1.19.4+"})
@Examples(value={"if load level of chunk at {_loc} = entity_ticking_level:", "\tdrop a diamond at {_loc}"})
@Since(value={"2.17.0"})
public class ExprChunkLoadLevel
extends SimplePropertyExpression<Chunk, Chunk.LoadLevel> {
    @Nullable
    public Chunk.LoadLevel convert(Chunk chunk) {
        return chunk.getLoadLevel();
    }

    @NotNull
    public Class<? extends Chunk.LoadLevel> getReturnType() {
        return Chunk.LoadLevel.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "chunk load level";
    }

    static {
        if (Types.HAS_CHUNK_LOAD_LEVEL) {
            ExprChunkLoadLevel.register(ExprChunkLoadLevel.class, Chunk.LoadLevel.class, (String)"[chunk] load level", (String)"chunks");
        }
    }
}

