/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Player Health Scale")
@Description(value={"Represents the scaled health of the player sent to the client.", "NOTE: This is not persistent, does not last restarts/relogs.", "NOTE: displayedHealth = (health * 2) / (max health * 2) * scale.", "NOTE: If the player is not currently health scaled, this will not be set."})
@Examples(value={"set health scale of all players to 10", "add 10 to health scale of player", "reset health scale of player", "set health scale of (\"BrettPlaysMC\" parsed as offline player) to 0.01"})
@Since(value={"2.7.2"})
public class ExprHealthScale
extends SimplePropertyExpression<Player, Number> {
    @Nullable
    public Number convert(Player player) {
        if (!player.isHealthScaled()) {
            return null;
        }
        return player.getHealthScale();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Integer changeNumber = delta != null && delta[0] instanceof Number ? (Number)((Number)delta[0]) : (Number)0;
        double change = Math.max(((Number)changeNumber).doubleValue(), 1.0);
        for (Player player : (Player[])this.getExpr().getArray(event)) {
            boolean scaled = true;
            double oldScale = player.getHealthScale();
            switch (mode) {
                case SET: {
                    oldScale = change;
                    break;
                }
                case ADD: {
                    oldScale += change;
                    break;
                }
                case REMOVE: {
                    oldScale -= change;
                    break;
                }
                case RESET: {
                    oldScale = 20.0;
                    scaled = false;
                }
            }
            player.setHealthScale(oldScale);
            player.setHealthScaled(scaled);
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "health scale";
    }

    static {
        ExprHealthScale.register(ExprHealthScale.class, Number.class, (String)"health scale", (String)"players");
    }
}

