/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Infinite Potion Effect")
@Description(value={"Represents an infinite potion effect. This is similar to Skript's potion effect expression except it is infinite time.", "This can be used in Skript's `apply %potion effects% to %living entities%` effect!", "\nNOTE: This will cause console errors when sending as a string (This is an issue in Skript itself).", "This is only a temp solution until Skript adds a proper solution. Requires Minecraft 1.19.4+"})
@Examples(value={"set {_potion} to infinite potion effect of night vision of tier 1 without particles", "apply {_potion} to player"})
@Since(value={"2.8.5"})
public class ExprInfinitePotionEffect
extends SimpleExpression<PotionEffect> {
    private boolean ambient;
    private boolean particles;
    private Expression<PotionEffectType> potionEffectTypes;
    private Expression<Number> tier;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.ambient = parseResult.hasTag("ambient");
        this.particles = !parseResult.hasTag("particles");
        this.potionEffectTypes = exprs[0];
        this.tier = exprs[1];
        return true;
    }

    @Nullable
    protected PotionEffect[] get(Event event) {
        Number tierNumber;
        int tier = 0;
        if (this.tier != null && (tierNumber = (Number)this.tier.getSingle(event)) != null) {
            tier = tierNumber.intValue() - 1;
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (PotionEffectType type : (PotionEffectType[])this.potionEffectTypes.getArray(event)) {
            PotionEffect potionEffect = new PotionEffect(type, -1, tier, this.ambient, this.particles);
            potionEffects.add(potionEffect);
        }
        return potionEffects.toArray(new PotionEffect[0]);
    }

    public boolean isSingle() {
        return this.potionEffectTypes.isSingle();
    }

    @NotNull
    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String ambient = this.ambient ? "ambient " : "";
        String tier = this.tier != null ? " of tier " + this.tier.toString(e, d) : "";
        String particles = this.particles ? " without particles" : "";
        return ambient + "potion effect of " + this.potionEffectTypes.toString(e, d) + tier + particles;
    }

    static {
        Skript.registerExpression(ExprInfinitePotionEffect.class, PotionEffect.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[new] [:ambient] infinite potion effect[s] of %potioneffecttypes% [[[of] tier] %number%] [particles:without particles]"});
    }
}

