/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ItemType From NamespacedKey/BlockData")
@Description(value={"Get an ItemType from a Minecraft namespaced key or BlockData."})
@Examples(value={"set {_i} to itemtype from namespaced key from \"minecraft:stone\"", "set {_i} to itemtype from block data of target block"})
@Since(value={"2.10.0"})
public class ExprItemFromNamespacedKey
extends SimpleExpression<ItemType> {
    private Expression<?> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        ArrayList<ItemType> itemTypes = new ArrayList<ItemType>();
        for (Object object : this.objects.getArray(event)) {
            Material material;
            if (object instanceof NamespacedKey) {
                NamespacedKey namespacedKey = (NamespacedKey)object;
                material = (Material)Registry.MATERIAL.get(namespacedKey);
                if (material == null) continue;
                itemTypes.add(new ItemType(material));
                continue;
            }
            if (!(object instanceof BlockData)) continue;
            BlockData blockData = (BlockData)object;
            material = blockData.getMaterial();
            itemTypes.add(new ItemType(material));
        }
        return itemTypes.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return this.objects.isSingle();
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "item type[s] from " + this.objects.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprItemFromNamespacedKey.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"item[ ]type[s] (from|of) %namespacedkeys/blockdatas%"});
    }
}

