/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Memory")
@Description(value={"Get/set memories of entities."})
@Examples(value={"set {_home} to home memory of {_villager}", "set home memory of last spawned villager to location of player"})
@Since(value={"3.4.0"})
public class ExprMemoryValue
extends SimplePropertyExpression<LivingEntity, Object> {
    private Literal<MemoryKey<?>> memory;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.memory = (Literal)exprs[matchedPattern];
        this.setExpr(exprs[matchedPattern == 0 ? 1 : 0]);
        return true;
    }

    @Nullable
    public Object convert(LivingEntity entity) {
        try {
            return entity.getMemory((MemoryKey)this.memory.getSingle());
        }
        catch (IllegalStateException ignore) {
            return null;
        }
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{((MemoryKey)this.memory.getSingle()).getMemoryClass()});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && delta != null && delta[0] != null) {
            MemoryKey memory = (MemoryKey)this.memory.getSingle();
            Object value = delta[0];
            if (value.getClass().isAssignableFrom(memory.getMemoryClass())) {
                for (LivingEntity livingEntity : (LivingEntity[])this.getExpr().getArray(event)) {
                    livingEntity.setMemory(memory, value);
                }
            }
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        return ((MemoryKey)this.memory.getSingle()).getMemoryClass();
    }

    @NotNull
    protected String getPropertyName() {
        return this.memory.toString() + " memory";
    }

    static {
        ExprMemoryValue.register(ExprMemoryValue.class, Object.class, (String)"%*memory% memory", (String)"livingentities");
    }
}

