/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Mob Awareness")
@Description(value={"Represents whether this mob is aware of its surroundings.", "Turning this off is essentially like turning off the mobs AI.", "Unaware mobs will still move if pushed, attacked, etc. but will not move or perform any actions on their own.", "Unaware mobs will still be affected by gravity.", "Unaware mobs may also have other unspecified behaviours disabled, such as drowning."})
@Examples(value={"if mob awareness of target entity = true:", "set mob awareness of target entity to false"})
@Since(value={"2.8.3"})
public class ExprMobAwareness
extends SimplePropertyExpression<Entity, Boolean> {
    @Nullable
    public Boolean convert(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.isAware();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Boolean) {
            Boolean aware = (Boolean)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.setAware(aware.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "mob awareness";
    }

    static {
        ExprMobAwareness.register(ExprMobAwareness.class, Boolean.class, (String)"mob awareness", (String)"entities");
    }
}

