/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.entity.Pathfinder;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Pathfinding - Path Target")
@Description(value={"Set the path of an entity to target a specific location, with an optional speed", "Get the location of the paths end. Delete will stop the entity from pathfinding. Requires Paper 1.13+"})
@Examples(value={"set path target of event-entity to player", "set path target with speed 1.5 of last spawned entity to location above player", "set path targets of all entities to location of player", "delete path target of event-entity"})
@Since(value={"1.5.0"})
public class ExprPathTarget
extends SimplePropertyExpression<LivingEntity, Location> {
    @Nullable
    private Expression<Number> speed;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!Skript.classExists((String)"com.destroystokyo.paper.entity.Pathfinder")) {
            Skript.error((String)"This expression requires a PaperMC server or a fork of.");
            return false;
        }
        this.setExpr(exprs[1]);
        this.speed = exprs[0];
        return true;
    }

    @Nullable
    public Location convert(@NotNull LivingEntity livingEntity) {
        Mob mob;
        Pathfinder pathfinder;
        if (livingEntity instanceof Mob && (pathfinder = (mob = (Mob)livingEntity).getPathfinder()).hasPath()) {
            Pathfinder.PathResult result = pathfinder.getCurrentPath();
            return result != null ? result.getFinalPoint() : null;
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[]{Location.class});
            default -> null;
        };
    }

    @Override
    public void change(@NotNull Event e, Object[] delta, @NotNull Changer.ChangeMode mode) {
        Location location = delta != null ? (Location)delta[0] : null;
        Integer number = this.speed != null ? (Number)((Number)this.speed.getSingle(e)) : (Number)0;
        block4: for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(e)) {
            if (!(entity instanceof Mob)) {
                this.error("Entity is not a pathfindable mob: " + Classes.toString((Object)entity));
                continue;
            }
            Mob mob = (Mob)entity;
            switch (mode) {
                case SET: {
                    if (location == null) continue block4;
                    if (number != null && ((Number)number).doubleValue() != 0.0) {
                        mob.getPathfinder().moveTo(location, ((Number)number).doubleValue());
                        continue block4;
                    }
                    mob.getPathfinder().moveTo(location);
                    continue block4;
                }
                case DELETE: {
                    mob.getPathfinder().stopPathfinding();
                }
            }
        }
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "path target";
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String speed = this.speed != null ? " with speed " + this.speed.toString(e, d) : "";
        return "path target" + speed + " of " + this.getExpr().toString(e, d);
    }

    static {
        ExprPathTarget.register(ExprPathTarget.class, Location.class, (String)"[final] path target[s] [with speed %-number%]", (String)"livingentities");
    }
}

