/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.coll.CollectionUtils;
import java.time.Duration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Player Idle Time")
@Description(value={"Get/reset the idle time of a player.", "The idle duration is reset when the player sends specific action packets.", "Requires Paper 1.20.2+"})
@Examples(value={"if idle time of player > 1 minute:", "\tkick player due to \"hanging out too long\""})
@Since(value={"3.0.0"})
public class ExprPlayerIdleTime
extends SimplePropertyExpression<Player, Timespan> {
    @Nullable
    public Timespan convert(Player player) {
        Duration idleDuration = player.getIdleDuration();
        return new Timespan(idleDuration.toMillis());
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode != Changer.ChangeMode.RESET) {
            return;
        }
        for (Player player : (Player[])this.getExpr().getArray(event)) {
            player.resetIdleDuration();
        }
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "idle time";
    }

    static {
        if (Skript.methodExists(Player.class, (String)"getIdleDuration", (Class[])new Class[0])) {
            ExprPlayerIdleTime.register(ExprPlayerIdleTime.class, Timespan.class, (String)"idle (time|duration)", (String)"players");
        }
    }
}

