/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Potion Effect Tier")
@Description(value={"Get the tier of a potion effect.", "\nNote: This is the Minecraft potion effect amplifier + 1, Skript adds 1 for some odd reason."})
@Examples(value={"set {_tiers::*} to potion tiers of active potion effects of player"})
@Since(value={"2.8.5"})
public class ExprPotionEffectTier
extends SimplePropertyExpression<PotionEffect, Number> {
    @Nullable
    public Number convert(PotionEffect potionEffect) {
        return potionEffect.getAmplifier() + 1;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "potion effect tier";
    }

    static {
        ExprPotionEffectTier.register(ExprPotionEffectTier.class, Number.class, (String)"potion [effect] (tier|amplifier)[s]", (String)"potioneffects");
    }
}

