/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Regeneration Rate")
@Description(value={"Represents the regeneration rate (1 health per x ticks) of the Player.", "\nSaturated = When they have saturation and their food level >= 20. Default is 10 ticks.", "\nUnsaturated = When they have no saturation and their food level >= 18. Default is 80 ticks."})
@Examples(value={"set {_regen} to saturated regen rate of player", "set unsaturated regen rate of player to 10 ticks", "add 1 second to unsaturated regen rate of player"})
@Since(value={"3.0.2"})
public class ExprRegenRate
extends SimplePropertyExpression<Player, Timespan> {
    private boolean saturated;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.saturated = !parseResult.hasTag("un");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Timespan convert(Player player) {
        int ticks = this.saturated ? player.getSaturatedRegenRate() : player.getUnsaturatedRegenRate();
        return new Timespan(Timespan.TimePeriod.TICK, (long)ticks);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Player[] playerArray;
        int changeValue;
        if (mode == Changer.ChangeMode.RESET) {
            changeValue = this.saturated ? 10 : 80;
        } else if (delta != null && (playerArray = delta[0]) instanceof Timespan) {
            Timespan timespan = (Timespan)playerArray;
            changeValue = (int)timespan.getAs(Timespan.TimePeriod.TICK);
        } else {
            return;
        }
        for (Player player : (Player[])this.getExpr().getArray(event)) {
            int previous;
            int n = previous = this.saturated ? player.getSaturatedRegenRate() : player.getUnsaturatedRegenRate();
            if (mode == Changer.ChangeMode.ADD) {
                changeValue += previous;
            } else if (mode == Changer.ChangeMode.REMOVE) {
                changeValue = previous - changeValue;
            }
            if (this.saturated) {
                player.setSaturatedRegenRate(changeValue);
                continue;
            }
            player.setUnsaturatedRegenRate(changeValue);
        }
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    protected String getPropertyName() {
        String saturated = this.saturated ? "saturated" : "unsaturated";
        return saturated + " regen rate";
    }

    static {
        if (Skript.methodExists(HumanEntity.class, (String)"getSaturatedRegenRate", (Class[])new Class[0])) {
            ExprRegenRate.register(ExprRegenRate.class, Timespan.class, (String)"[:un]saturated regen[eration] rate", (String)"players");
        }
    }
}

