/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Simulation Distance")
@Description(value={"Get/change simulation distance of a player/world.", "This represents the distance (in chunks) that entities/blocks outside of this distance will not tick.", "\nNOTE: Must be a value between 2 and 32."})
@Examples(value={"set simulation distance of all players to 2", "add 1 to simulation distance of world \"world\"", "set {_sim} to simulation distance of world of player"})
@Since(value={"2.6.0"})
public class ExprSimulationDistance
extends SimplePropertyExpression<Object, Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(Player.class, (String)"setSimulationDistance", (Class[])new Class[]{Integer.TYPE})) {
            Skript.error((String)"This expressions requires a PaperMC server.");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Object object) {
        return this.getSimulationDistance(object);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.DELETE -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Integer num = delta != null ? (Number)((Number)delta[0]) : (Number)0;
        int changeValue = num;
        for (Object object : this.getExpr().getArray(event)) {
            int oldValue = this.getSimulationDistance(object);
            int newValue = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Changer.ChangeMode.SET -> changeValue;
                case Changer.ChangeMode.ADD -> oldValue + changeValue;
                case Changer.ChangeMode.REMOVE -> oldValue - changeValue;
                case Changer.ChangeMode.RESET -> Bukkit.getSimulationDistance();
                case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.DELETE -> 0;
            };
            newValue = MathUtil.clamp(newValue, 2, 32);
            this.setSimulationDistance(object, newValue);
        }
    }

    private void setSimulationDistance(Object object, int changeValue) {
        if (object instanceof World) {
            World world = (World)object;
            world.setSimulationDistance(changeValue);
        } else if (object instanceof Player) {
            Player player = (Player)object;
            player.setSimulationDistance(changeValue);
        }
    }

    private int getSimulationDistance(Object object) {
        if (object instanceof World) {
            World world = (World)object;
            return world.getSimulationDistance();
        }
        if (object instanceof Player) {
            Player player = (Player)object;
            return player.getSimulationDistance();
        }
        return 0;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "simulation distance";
    }

    static {
        if (!Util.IS_RUNNING_SKRIPT_2_11) {
            ExprSimulationDistance.register(ExprSimulationDistance.class, Number.class, (String)"simulation distance", (String)"players/worlds");
        }
    }
}

