/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawn Egg from Entity")
@Description(value={"Gets a spawn egg from an entity/entityType. Requires Paper, or Spigot 1.20.1+."})
@Examples(value={"set {_egg} to spawn egg of last spawned entity", "set {_egg} to spawn egg of (spawner type of target block)"})
@Since(value={"2.14.0"})
public class ExprSpawnEggFromEntity
extends SimplePropertyExpression<Object, ItemType> {
    private static final ItemFactory ITEM_FACTORY = Bukkit.getItemFactory();

    @Nullable
    public ItemType convert(Object object) {
        EntityType entityType;
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            entityType = entity.getType();
        } else if (object instanceof EntityData) {
            EntityData entityData = (EntityData)object;
            entityType = EntityUtils.toBukkitEntityType((EntityData)entityData);
        } else {
            return null;
        }
        if (entityType == null) {
            return null;
        }
        Material spawnEggObject = ITEM_FACTORY.getSpawnEgg(entityType);
        if (spawnEggObject instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)spawnEggObject;
            return new ItemType(itemStack);
        }
        if (spawnEggObject instanceof Material) {
            Material material = spawnEggObject;
            return new ItemType(material);
        }
        return null;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "spawn egg";
    }

    static {
        if (Skript.methodExists(ItemFactory.class, (String)"getSpawnEgg", (Class[])new Class[]{EntityType.class})) {
            ExprSpawnEggFromEntity.register(ExprSpawnEggFromEntity.class, ItemType.class, (String)"spawn egg", (String)"entities/entitydatas");
        }
    }
}

