/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner - Spawn Delay")
@Description(value={"The delay between a spawner spawning a new entity.", "Maximum default is 800 ticks (40 seconds).", "Minimum default is 200 ticks (10 seconds)."})
@Examples(value={"on place of mob spawner:", "\tset spawner spawn delay of event-block to 3 seconds", "\tadd 100 to max spawn delay of event-block", "\tremove 1 second from min spawn delay of event-block", "\treset spawn delay of event-block"})
@Since(value={"2.16.0"})
public class ExprSpawnerSpawnDelay
extends SimplePropertyExpression<Block, Timespan> {
    private static final int DEFAULT_MAX_TICKS = 800;
    private static final int DEFAULT_MIN_TICKS = 200;
    private Kleenean action;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.action = Kleenean.get((int)parseResult.mark);
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Timespan convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            int delay = switch (this.action) {
                case Kleenean.FALSE -> spawner.getMinSpawnDelay();
                case Kleenean.TRUE -> spawner.getMaxSpawnDelay();
                default -> spawner.getDelay();
            };
            return new Timespan(Timespan.TimePeriod.TICK, (long)delay);
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class, Number.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changeValue = 0;
        if (delta != null) {
            Object object = delta[0];
            if (object instanceof Timespan) {
                Timespan timespan = (Timespan)object;
                changeValue = (int)timespan.getAs(Timespan.TimePeriod.TICK);
            } else {
                object = delta[0];
                if (object instanceof Number) {
                    Number number = (Number)object;
                    changeValue = number.intValue();
                }
            }
        } else {
            changeValue = switch (this.action) {
                case Kleenean.TRUE -> 800;
                case Kleenean.FALSE -> 200;
                default -> 0;
            };
        }
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            BlockState blockState = block.getState();
            if (!(blockState instanceof CreatureSpawner)) continue;
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            int value = switch (this.action) {
                case Kleenean.TRUE -> spawner.getMaxSpawnDelay();
                case Kleenean.FALSE -> spawner.getMinSpawnDelay();
                default -> spawner.getDelay();
            };
            switch (mode) {
                case REMOVE: {
                    value -= changeValue;
                    break;
                }
                case ADD: {
                    value += changeValue;
                    break;
                }
                case SET: 
                case RESET: {
                    value = changeValue;
                }
            }
            value = Math.max(value, 0);
            switch (this.action) {
                case TRUE: {
                    if (value < spawner.getMinSpawnDelay()) {
                        spawner.setMinSpawnDelay(value);
                    }
                    spawner.setMaxSpawnDelay(value);
                    break;
                }
                case FALSE: {
                    if (value > spawner.getMaxSpawnDelay()) {
                        spawner.setMaxSpawnDelay(value);
                    }
                    spawner.setMinSpawnDelay(value);
                    break;
                }
                default: {
                    spawner.setDelay(value);
                }
            }
            spawner.update();
        }
    }

    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    protected String getPropertyName() {
        return (switch (this.action) {
            case Kleenean.TRUE -> "maximum ";
            case Kleenean.FALSE -> "minimum ";
            default -> "";
        }) + "spawn delay";
    }

    static {
        ExprSpawnerSpawnDelay.register(ExprSpawnerSpawnDelay.class, Timespan.class, (String)"[(-1:min|1:max)[imum]] [spawner] spawn delay", (String)"blocks");
    }
}

