/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Spellcaster;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Spellcaster Spell")
@Description(value={"Get/set/reset the spell of a spell casting entity (Illusioner, Evoker)."})
@Examples(value={"set spell of target entity to fangs", "reset spell of target entity"})
@Since(value={"1.17.0"})
public class ExprSpellcasterSpell
extends SimplePropertyExpression<Entity, Spellcaster.Spell> {
    @Nullable
    public Spellcaster.Spell convert(Entity entity) {
        if (entity instanceof Spellcaster) {
            Spellcaster spellcaster = (Spellcaster)entity;
            return spellcaster.getSpell();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Spellcaster.Spell.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Spellcaster.Spell spell = delta != null ? (Spellcaster.Spell)delta[0] : Spellcaster.Spell.NONE;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof Spellcaster)) continue;
            Spellcaster spellcaster = (Spellcaster)entity;
            spellcaster.setSpell(spell);
        }
    }

    @NotNull
    public Class<? extends Spellcaster.Spell> getReturnType() {
        return Spellcaster.Spell.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "spell";
    }

    static {
        ExprSpellcasterSpell.register(ExprSpellcasterSpell.class, Spellcaster.Spell.class, (String)"[spellcaster] spell", (String)"entities");
    }
}

