/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="View Distance")
@Description(value={"Get/change view distance of a player/world.", "This represents the distance (in chunks) that will be sent to the player.", "\nNOTE: Must be a value between 2 and 32.", "\nWhile I understand Skript has this, it's been disabled in Skript due to previous PaperMC issues."})
@Examples(value={"set view distance of all players to 2", "add 1 to view distance of world \"world\"", "set {_sim} to view distance of world of player"})
@Since(value={"2.6.0"})
public class ExprViewDistance
extends SimplePropertyExpression<Object, Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.methodExists(Player.class, (String)"setViewDistance", (Class[])new Class[]{Integer.TYPE})) {
            Skript.error((String)"This expressions requires a PaperMC server.");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Object object) {
        return this.getViewDistance(object);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.DELETE -> null;
        };
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Integer num;
        Number number = num = delta != null ? (Number)((Number)delta[0]) : (Number)0;
        if (num == null) {
            this.error("Number is not set: " + String.valueOf(num));
            return;
        }
        int changeValue = num;
        for (Object object : this.getExpr().getArray(event)) {
            int oldValue = this.getViewDistance(object);
            int newValue = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case Changer.ChangeMode.SET -> changeValue;
                case Changer.ChangeMode.ADD -> oldValue + changeValue;
                case Changer.ChangeMode.REMOVE -> oldValue - changeValue;
                case Changer.ChangeMode.RESET -> Bukkit.getViewDistance();
                case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.DELETE -> 0;
            };
            newValue = MathUtil.clamp(newValue, 2, 32);
            this.setViewDistance(object, newValue);
        }
    }

    private void setViewDistance(Object object, int changeValue) {
        if (object instanceof World) {
            World world = (World)object;
            world.setViewDistance(changeValue);
        } else if (object instanceof Player) {
            Player player = (Player)object;
            player.setViewDistance(changeValue);
        }
    }

    private int getViewDistance(Object object) {
        if (object instanceof World) {
            World world = (World)object;
            return world.getViewDistance();
        }
        if (object instanceof Player) {
            Player player = (Player)object;
            return player.getViewDistance();
        }
        return 0;
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "view distance";
    }

    static {
        if (!Util.IS_RUNNING_SKRIPT_2_11) {
            ExprViewDistance.register(ExprViewDistance.class, Number.class, (String)"view distance", (String)"players/worlds");
        }
    }
}

