/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.type;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.BukkitUtils;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.SimpleJavaFunction;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.DefaultClasses;
import ch.njol.skript.util.Timespan;
import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.MathUtil;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.EnumWrapper;
import com.shanebeestudios.skbee.api.wrapper.RegistryClassInfo;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import java.io.StreamCorruptedException;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.EntityEffect;
import org.bukkit.JukeboxSong;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.TreeType;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Types {
    public static boolean HAS_ARMOR_TRIM;
    public static boolean HAS_CHUNK_LOAD_LEVEL;

    static {
        EnumWrapper<EntityRemoveEvent.Cause> CAUSE_ENUM;
        HAS_ARMOR_TRIM = Skript.classExists((String)"org.bukkit.inventory.meta.trim.ArmorTrim");
        HAS_CHUNK_LOAD_LEVEL = Skript.classExists((String)"org.bukkit.Chunk$LoadLevel");
        if (Classes.getExactClassInfo(Spellcaster.Spell.class) == null) {
            EnumWrapper<Spellcaster.Spell> SPELL_ENUM = new EnumWrapper<Spellcaster.Spell>(Spellcaster.Spell.class);
            Classes.registerClass((ClassInfo)SPELL_ENUM.getClassInfo("spell").user(new String[]{"spells?"}).name("Spellcaster Spell").description(new String[]{"Represents the different spells of a spellcaster.", "NOTE: These are auto-generated and may differ between server versions."}).since("1.17.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'spell' already.", new Object[0]);
            Util.logLoading("You may have to use their spells in SkBee's 'Spell-caster Spell' expression.", new Object[0]);
        }
        if (Classes.getExactClassInfo(NamespacedKey.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(NamespacedKey.class, "namespacedkey").user(new String[]{"namespacedkeys?"}).name("NamespacedKey").description(new String[]{"NamespacedKeys are a way to declare and specify game objects in Minecraft,", "which can identify built-in and user-defined objects without potential ambiguity or conflicts.", "For more information see [**Resource Location**](https://minecraft.wiki/w/Resource_location) on McWiki."}).since("2.6.0").parser(SkriptUtils.getDefaultParser()).serializer((Serializer)new Serializer<NamespacedKey>(){

                @NotNull
                public Fields serialize(NamespacedKey namespacedKey) {
                    Fields fields = new Fields();
                    fields.putObject("key", (Object)namespacedKey.toString());
                    return fields;
                }

                public void deserialize(NamespacedKey o, Fields f) {
                }

                protected NamespacedKey deserialize(Fields fields) throws StreamCorruptedException {
                    String key = (String)fields.getObject("key", String.class);
                    if (key == null) {
                        throw new StreamCorruptedException("NamespacedKey string is null");
                    }
                    return NamespacedKey.fromString((String)key);
                }

                public boolean mustSyncDeserialization() {
                    return true;
                }

                protected boolean canBeInstantiated() {
                    return false;
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'namespaced key' already.", new Object[0]);
            Util.logLoading("You may have to use their NamespacedKeys in SkBee's synaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(BlockFace.class) == null) {
            EnumWrapper<BlockFace> BLOCK_FACE_ENUM = new EnumWrapper<BlockFace>(BlockFace.class, "", "face");
            Classes.registerClass((ClassInfo)BLOCK_FACE_ENUM.getClassInfo("blockface").user(new String[]{"blockfaces?"}).name("BlockFace").description(new String[]{"Represents the face of a block.", "NOTE: These are auto-generated and may differ between server versions."}).since("2.6.0").defaultExpression((DefaultExpression)new SimpleLiteral((Object)BlockFace.NORTH, true)));
        } else {
            Util.logLoading("It looks like another addon registered 'blockFace' already.", new Object[0]);
            Util.logLoading("You may have to use their BlockFace in SkBee's syntaxes.", new Object[0]);
        }
        if (Skript.methodExists(PlayerRespawnEvent.class, (String)"getRespawnReason", (Class[])new Class[0]) || Skript.classExists((String)"io.papermc.paper.event.player.AbstractRespawnEvent")) {
            EnumWrapper<PlayerRespawnEvent.RespawnReason> RESPAWN_REASON_ENUM = new EnumWrapper<PlayerRespawnEvent.RespawnReason>(PlayerRespawnEvent.RespawnReason.class, "", "respawn");
            Classes.registerClass((ClassInfo)RESPAWN_REASON_ENUM.getClassInfo("respawnreason").user(new String[]{"respawn ?reasons?"}).name("Respawn Reason").description(new String[]{"Represents the reason the respawn event was called. Requires MC 1.19.4+", "NOTE: These are auto-generated and may differ between server versions."}).examples(new String[]{"on respawn:", "\tif respawn reason = death respawn:", "\t\tgive player 10 diamonds"}).since("2.8.4"));
        }
        if (Classes.getExactClassInfo(BlockState.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(BlockState.class, "blockstate").user(new String[]{"blockstates?"}).name("BlockState").description(new String[]{"Represents a captured state of a block, which will not change automatically.", "Unlike Block, which only one object can exist per coordinate, BlockState can exist multiple times for any given Block.", "In a structure, this represents how the block is saved to the structure.", "Requires MC 1.17.1+"}).since("1.12.3").parser((Parser)new Parser<BlockState>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(BlockState blockState, int flags) {
                    return String.format("BlockState{type=%s,location=%s}", blockState.getType(), blockState.getLocation());
                }

                @NotNull
                public String toVariableNameString(BlockState blockState) {
                    return this.toString(blockState, 0);
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'blockState' already.", new Object[0]);
            Util.logLoading("You may have to use their BlockState in SkBee's syntaxes.", new Object[0]);
        }
        if (HAS_ARMOR_TRIM && Classes.getExactClassInfo(ArmorTrim.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(ArmorTrim.class, "armortrim").user(new String[]{"armor ?trims?"}).name("ArmorTrim").description(new String[]{"Represents an armor trim that may be applied to an item.", "Requires MC 1.19.4+"}).since("2.13.0").parser((Parser)new Parser<ArmorTrim>(){

                public boolean canParse(@NotNull ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(ArmorTrim o, int flags) {
                    String material = o.getMaterial().getKey().getKey();
                    String pattern = o.getPattern().getKey().getKey();
                    return String.format("ArmorTrim{material='%s',pattern='%s'}", material, pattern);
                }

                @NotNull
                public String toVariableNameString(ArmorTrim o) {
                    return this.toString(o, 0);
                }
            }));
        }
        if (Classes.getExactClassInfo(TrimMaterial.class) == null) {
            Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.TRIM_MATERIAL, TrimMaterial.class, "trimmaterial", null, "material").user(new String[]{"trim ?materials?"}).name("ArmorTrim - TrimMaterial").description(new String[]{"Represents a material that may be used in an ArmorTrim.", "NOTE: These are auto-generated and may differ between server versions."}).since("2.13.0"));
        }
        if (Classes.getExactClassInfo(TrimPattern.class) == null) {
            Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.TRIM_PATTERN, TrimPattern.class, "trimpattern", null, "pattern").user(new String[]{"trim ?patterns?"}).name("ArmorTrim - TrimPattern").description(new String[]{"Represents a pattern that may be used in an ArmorTrim.", "NOTE: These are auto-generated and may differ between server versions."}).since("2.13.0"));
        }
        if (HAS_CHUNK_LOAD_LEVEL && Classes.getExactClassInfo(Chunk.LoadLevel.class) == null) {
            EnumWrapper<Chunk.LoadLevel> LOAD_LEVEL_ENUM = new EnumWrapper<Chunk.LoadLevel>(Chunk.LoadLevel.class, "", "level");
            Classes.registerClass((ClassInfo)LOAD_LEVEL_ENUM.getClassInfo("chunkloadlevel").user(new String[]{"chunk ?load ?levels?"}).name("Chunk Load Level").description(new String[]{"Represents the types of load levels of a chunk.", "- `border_level` = Most game logic is not processed, including entities and redstone.", "- `entity_ticking_level` = All game logic is processed.", "- `inaccessible_level` = No game logic is processed, world generation may still occur.", "- `ticking_level` = All game logic except entities is processed.", "- `unloaded_level` = This chunk is not loaded.", "NOTE: These are auto-generated and may differ between server versions."}).since("2.17.0"));
        }
        if (Classes.getExactClassInfo(EntityEffect.class) == null) {
            EnumWrapper<EntityEffect> ENTITY_EFFECT_ENUM = new EnumWrapper<EntityEffect>(EntityEffect.class);
            Classes.registerClass((ClassInfo)ENTITY_EFFECT_ENUM.getClassInfo("entityeffect").user(new String[]{"entit(y|ies) ?effects?"}).name("Entity Effect").description(new String[]{"Represents an effect that can be played on an entity.", "NOTE: These are auto-generated and may differ between server versions."}).since("3.0.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'EntityEffect' already.", new Object[0]);
            Util.logLoading("You may have to use their EntityEffects in SkBee's 'play entity effect' effect.", new Object[0]);
        }
        if (Classes.getExactClassInfo(MemoryKey.class) == null) {
            Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.MEMORY_MODULE_TYPE, MemoryKey.class, "memory").user(new String[]{"memor(y|ies)"}).name("Memory").description(new String[]{"Represents the different memories of an entity.", "NOTE: These are auto-generated and may differ between server versions."}));
        } else {
            Util.logLoading("It looks like another addon registered 'memory' already.", new Object[0]);
            Util.logLoading("You may have to use their ItemFlags in SkBee's syntaxes.", new Object[0]);
        }
        if (!Util.IS_RUNNING_SKRIPT_2_11) {
            if (Classes.getExactClassInfo(EquipmentSlot.class) == null) {
                EnumWrapper<EquipmentSlot> SLOT_ENUM = new EnumWrapper<EquipmentSlot>(EquipmentSlot.class, null, "slot");
                Classes.registerClass((ClassInfo)SLOT_ENUM.getClassInfo("equipmentslot").user(new String[]{"equipment ?slots?"}).name("Equipment Slot").description(new String[]{"Represents different slots of an entity.", "NOTE: These are auto-generated and may differ between server versions."}).since("3.4.0"));
            } else {
                Util.logLoading("It looks like another addon registered 'slot' already.", new Object[0]);
                Util.logLoading("You may have to use their EquipmentSlot in SkBee's syntaxes.", new Object[0]);
            }
        }
        if (Classes.getExactClassInfo(Action.class) == null) {
            EnumWrapper<Action> ACTION_ENUM = new EnumWrapper<Action>(Action.class);
            Classes.registerClass((ClassInfo)ACTION_ENUM.getClassInfo("blockaction").user(new String[]{"block ?actions?"}).name("Block Action").description(new String[]{"Represents different wants to interact.", "NOTE: These are auto-generated and may differ between server versions."}).since("3.4.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'blockaction' already.", new Object[0]);
            Util.logLoading("You may have to use their BlockAction in SkBee's syntaxes.", new Object[0]);
        }
        if (Skript.classExists((String)"org.bukkit.event.entity.EntityRemoveEvent") && Classes.getExactClassInfo(EntityRemoveEvent.Cause.class) == null) {
            CAUSE_ENUM = new EnumWrapper<EntityRemoveEvent.Cause>(EntityRemoveEvent.Cause.class);
            Classes.registerClass((ClassInfo)CAUSE_ENUM.getClassInfo("entityremovecause").user(new String[]{"entity ?remove ?causes?"}).name("Entity Remove Cause").description(new String[]{"Represents the reasons an entity was removed from the world.", "NOTE: These are auto-generated and may differ between server versions."}).after(new String[]{"damagecause", "damagetype"}).since("3.4.0"));
        }
        if (Skript.classExists((String)"org.bukkit.event.player.PlayerSpawnChangeEvent") && Classes.getExactClassInfo(PlayerSpawnChangeEvent.Cause.class) == null) {
            CAUSE_ENUM = new EnumWrapper<PlayerSpawnChangeEvent.Cause>(PlayerSpawnChangeEvent.Cause.class);
            Classes.registerClass((ClassInfo)CAUSE_ENUM.getClassInfo("playerspawnchangereason").user(new String[]{"player ?spawn ?change ?reasons?"}).name("Player Spawn Change Reason").description(new String[]{"Represents the reasons why a player changed their spawn location.", "NOTE: These are auto-generated and may differ between server versions."}).after(new String[]{"damagecause", "damagetype", "itemtype"}).since("3.4.0"));
        }
        if (Classes.getExactClassInfo(EntityType.class) == null) {
            Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.ENTITY_TYPE, EntityType.class, "minecraftentitytype").user(new String[]{"minecraft ?entity ?types?"}).name("Minecraft - EntityType").description(new String[]{"Represents a Minecraft entity.", "These differ slightly from Skript's EntityType as the names match Minecraft namespaces.", "These also support the use of the Minecraft namespace as well as underscores.", "NOTE: These are auto-generated and may differ between server versions."}).examples(new String[]{"mc spawn sheep at player", "mc spawn minecraft:sheep at player", "mc spawn minecraft:armor_stand at player"}).after(new String[]{"entitydata", "entitydata"}).since("3.5.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'minecraftEntityType' already.", new Object[0]);
            Util.logLoading("You may have to use their Minecraft EntityType in SkBee's syntaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Color.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Color.class, "bukkitcolor").user(new String[]{"bukkit ?colors?"}).name("Bukkit Color").description(new String[]{"Represents a Bukkit color. This is different than a Skript color", "as it adds an alpha channel."}).since("2.8.0").parser((Parser)new Parser<Color>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(Color bukkitColor, int flags) {
                    int alpha = bukkitColor.getAlpha();
                    int red = bukkitColor.getRed();
                    int green = bukkitColor.getGreen();
                    int blue = bukkitColor.getBlue();
                    return String.format("BukkitColor(a=%s,r=%s,g=%s,b=%s)", alpha, red, green, blue);
                }

                @NotNull
                public String toVariableNameString(Color bukkitColor) {
                    return this.toString(bukkitColor, 0);
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'bukkitColor' already.", new Object[0]);
            Util.logLoading("You may have to use their Color in SkBee's syntaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(TreeType.class) == null) {
            EnumWrapper<TreeType> TREE_TYPE = new EnumWrapper<TreeType>(TreeType.class, "", "tree");
            Classes.registerClass((ClassInfo)TREE_TYPE.getClassInfo("bukkittreetype").user(new String[]{"bukkit ?tree ?types?"}).name("Bukkit Tree Type").description(new String[]{"Represents the different types of trees.", "NOTE: These are auto-generated and may differ between server versions."}).after(new String[]{"structuretype"}).since("3.5.3"));
        } else {
            Util.logLoading("It looks like another addon registered 'tree' already.", new Object[0]);
            Util.logLoading("You may have to use their TreeType in SkBee's syntaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Pose.class) == null) {
            EnumWrapper<Pose> POSE = new EnumWrapper<Pose>(Pose.class, "", "pose");
            Classes.registerClass((ClassInfo)POSE.getClassInfo("pose").user(new String[]{"poses?"}).name("Entity Pose").description(new String[]{"Represents the pose of an entity.", "NOTE: These are auto-generated and may differ between server versions."}).since("3.5.4"));
        } else {
            Util.logLoading("It looks like another addon registered 'pose' already.", new Object[0]);
            Util.logLoading("You may have to use their Pose in SkBee's syntaxes.", new Object[0]);
        }
        if (Skript.classExists((String)"org.bukkit.inventory.EquipmentSlotGroup")) {
            if (Classes.getExactClassInfo(EquipmentSlotGroup.class) == null) {
                final Map<String, EquipmentSlotGroup> equipmentSlotGroups = SkriptUtils.getEquipmentSlotGroups();
                Classes.registerClass((ClassInfo)new ClassInfo(EquipmentSlotGroup.class, "equipmentslotgroup").user(new String[]{"equipment ?slot ?groups?"}).name("Equipment Slot Group").description(new String[]{"Represents different groups of equipment slots.", "NOTE: These are auto-generated and may differ between server versions."}).usage(new String[]{StringUtils.join(equipmentSlotGroups.keySet().stream().sorted().toList(), (String)", ")}).parser((Parser)new Parser<EquipmentSlotGroup>(){

                    @Nullable
                    public EquipmentSlotGroup parse(String string, ParseContext context) {
                        string = string.replace(" ", "_");
                        return (EquipmentSlotGroup)equipmentSlotGroups.get(string);
                    }

                    @NotNull
                    public String toString(EquipmentSlotGroup slot, int flags) {
                        return slot.toString();
                    }

                    @NotNull
                    public String toVariableNameString(EquipmentSlotGroup slot) {
                        return slot.toString();
                    }
                }));
            } else {
                Util.logLoading("It looks like another addon registered 'equipmentSlotGroup' already.", new Object[0]);
                Util.logLoading("You may have to use their EquipmentSlotGroup in SkBee's syntaxes.", new Object[0]);
            }
        }
        if (Classes.getExactClassInfo(AttributeModifier.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(AttributeModifier.class, "attributemodifier").user(new String[]{"attribute ?modifiers?"}).name("Attribute Modifier").description(new String[]{"Represents an attribute modifier from an item/living entity."}).parser((Parser)new Parser<AttributeModifier>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(AttributeModifier modifier, int flags) {
                    return ItemUtils.attributeModifierToString(modifier);
                }

                @NotNull
                public String toVariableNameString(AttributeModifier o) {
                    return this.toString(o, 0);
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'attributeModifier' already.", new Object[0]);
            Util.logLoading("You may have to use their AttributeModifier in SkBee's syntaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(AttributeModifier.Operation.class) == null) {
            Classes.registerClass((ClassInfo)new EnumWrapper<AttributeModifier.Operation>(AttributeModifier.Operation.class).getClassInfo("attributeoperation").user(new String[]{"attribute ?operations?"}).name("Attribute Modifier Operation").description(new String[]{"Represents the different operations of an attribute modifer.", "NOTE: These are auto-generated and may differ between server versions."}));
        } else {
            Util.logLoading("It looks like another addon registered 'attributeOperation' already.", new Object[0]);
            Util.logLoading("You may have to use their AttributeModifier Operation in SkBee's syntaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(PotionType.class) == null) {
            if (BukkitUtils.registryExists((String)"POTION")) {
                Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.POTION, PotionType.class, "potiontype").user(new String[]{"potion ?types?"}).name("Potion Type").description(new String[]{"Represents the different types of potions (not potion effect types) used in vanilla potion items."}).after(new String[]{"potioneffecttype", "itemtype"}).since("3.8.0"));
                SkriptUtils.hackPotionEffectTypeClassInfoPattern();
            }
        } else {
            Util.logLoading("It looks like another addon registered 'potiontype' already.", new Object[0]);
            Util.logLoading("You may have to use their PotionType in SkBee's syntaxes.", new Object[0]);
        }
        if (Classes.getExactClassInfo(MusicInstrument.class) == null) {
            if (BukkitUtils.registryExists((String)"INSTRUMENT")) {
                Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.INSTRUMENT, MusicInstrument.class, "instrument").user(new String[]{"instruments?"}).name("Instrument").description(new String[]{"Represents the instruments used by goat horns.", "Requires Minecraft 1.20.6+", "NOTE: These are auto-generated and may differ between server versions."}).since("3.8.0"));
            }
        } else {
            Util.logLoading("It looks like another addon registered 'instrument' already.", new Object[0]);
            Util.logLoading("You may have to use their Instruments in SkBee's syntaxes.", new Object[0]);
        }
        if (Skript.classExists((String)"org.bukkit.JukeboxSong")) {
            if (Classes.getExactClassInfo(JukeboxSong.class) == null) {
                if (BukkitUtils.registryExists((String)"JUKEBOX_SONG")) {
                    Classes.registerClass((ClassInfo)RegistryClassInfo.create(Registry.JUKEBOX_SONG, JukeboxSong.class, "jukeboxsong").user(new String[]{"jukebox ?songs?"}).name("Instrument").description(new String[]{"Represents the songs for jukeboxes.", "Requires Minecraft 1.21+", "NOTE: These are auto-generated and may differ between server versions."}).since("3.8.0"));
                }
            } else {
                Util.logLoading("It looks like another addon registered 'jukeboxson' already.", new Object[0]);
                Util.logLoading("You may have to use their JukeboxSongs in SkBee's syntaxes.", new Object[0]);
            }
        }
        if (Skript.classExists((String)"io.papermc.paper.event.player.PlayerFailMoveEvent$FailReason") && Classes.getExactClassInfo(PlayerFailMoveEvent.FailReason.class) == null) {
            Classes.registerClass((ClassInfo)new EnumWrapper<PlayerFailMoveEvent.FailReason>(PlayerFailMoveEvent.FailReason.class).getClassInfo("failmovereason").user(new String[]{"fail ?move ?reasons?"}).description(new String[]{"The reason a player failed to move in a `player fail move` event."}).since("3.11.0"));
        }
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Color>("bukkitColor", new Parameter[]{new Parameter("alpha", DefaultClasses.NUMBER, true, null), new Parameter("red", DefaultClasses.NUMBER, true, null), new Parameter("green", DefaultClasses.NUMBER, true, null), new Parameter("blue", DefaultClasses.NUMBER, true, null)}, Classes.getExactClassInfo(Color.class), true){

            @Nullable
            public Color[] executeSimple(Object[][] params) {
                int alpha = ((Number)params[0][0]).intValue();
                int red = ((Number)params[1][0]).intValue();
                int green = ((Number)params[2][0]).intValue();
                int blue = ((Number)params[3][0]).intValue();
                alpha = MathUtil.clamp(alpha, 0, 255);
                red = MathUtil.clamp(red, 0, 255);
                green = MathUtil.clamp(green, 0, 255);
                blue = MathUtil.clamp(blue, 0, 255);
                return new Color[]{Color.fromARGB((int)alpha, (int)red, (int)green, (int)blue)};
            }
        }.description(new String[]{"Creates a new Bukkit Color using alpha (transparency), red, green and blue channels.", "Number values must be between 0 and 255."}).examples(new String[]{"set {_color} to bukkitColor(50,155,100,10)"}).since("2.8.0"));
        ClassInfo timePeriodInfo = Classes.getExactClassInfo(Timespan.TimePeriod.class);
        if (timePeriodInfo == null) {
            timePeriodInfo = new EnumWrapper<Timespan.TimePeriod>(Timespan.TimePeriod.class, true).getClassInfo("timespanperiod").user(new String[]{"time ?span ?periods?"}).name("Timespan Period").description(new String[]{"Represents the time periods of a Timespan."}).since("3.9.0");
            Classes.registerClass((ClassInfo)timePeriodInfo);
        }
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Timespan>("timespan", new Parameter[]{new Parameter("time", DefaultClasses.NUMBER, true, null), new Parameter("timeperiod", timePeriodInfo, true, null)}, DefaultClasses.TIMESPAN, true){

            public Timespan @Nullable [] executeSimple(Object[][] params) {
                long time = ((Number)params[0][0]).longValue();
                Timespan.TimePeriod timePeriod = (Timespan.TimePeriod)params[1][0];
                if (time >= 0L) {
                    return new Timespan[]{new Timespan(timePeriod, time)};
                }
                return null;
            }
        }.description(new String[]{"Create a new Timespan."}).examples(new String[]{"set {_time} to timespan(1, minute)", "set {_time} to timespan(10, minutes)", "set {_time} to timespan(3, ticks)", "set {_time} to timespan(1, hour) + timespan(10, minutes)"}).since("3.9.0"));
    }
}

