/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.raytrace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import com.shanebeestudios.skbee.api.util.EntityUtils;
import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="RayTrace - From Location")
@Description(value={"RayTrace from a location along a vector.", "Default max distance = 'maximum target block distance' in Skript's config.", "RaySize = entity bounding boxes will be uniformly expanded (or shrunk)", "by this value before doing collision checks (default = 0.0).", "IngorePassableBlocks = Will ignore passable but collidable blocks (ex. tall grass, signs, fluids, ..). [Added in SkBee 3.0.0]", "Ignoring Entities/EntityTypes = Will ignore the entities/entitytypes from the final ray. [Added in SkBee 3.5.0]", "Going through Blocks/ItemTypes = Will ignore the blocks/itemtypes from the final ray. [Added in SkBee INSERTVERSION]"})
@Examples(value={"set {_ray} to ray trace from location of target block along vector(0.25,0.3,0) with max distance 50"})
@Since(value={"2.6.0"})
public class ExprRayTraceFromLocation
extends SimpleExpression<RayTraceResult> {
    private Expression<Location> location;
    private Expression<Vector> vectors;
    private Expression<Number> maxDistance;
    private Expression<Number> raySize;
    private boolean ignore;
    private Expression<?> ignoredEntities;
    private Expression<?> ignoredBlocks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = exprs[0];
        this.vectors = exprs[1];
        this.maxDistance = exprs[2];
        this.raySize = exprs[3];
        this.ignore = parseResult.hasTag("ignore");
        this.ignoredEntities = exprs[4];
        this.ignoredBlocks = exprs[5];
        return true;
    }

    protected RayTraceResult @Nullable [] get(Event event) {
        Location location;
        Number raySizeNum;
        Number single;
        Object[] ignoredEntities = this.ignoredEntities != null ? this.ignoredEntities.getArray(event) : null;
        Object[] ignoredBlocks = this.ignoredBlocks != null ? this.ignoredBlocks.getArray(event) : null;
        double maxDistance = ((Integer)SkriptConfig.maxTargetBlockDistance.value()).intValue();
        if (this.maxDistance != null && (single = (Number)this.maxDistance.getSingle(event)) != null) {
            maxDistance = single.doubleValue();
        }
        double raySize = 0.0;
        if (this.raySize != null && (raySizeNum = (Number)this.raySize.getSingle(event)) != null) {
            raySize = raySizeNum.doubleValue();
        }
        if ((location = (Location)this.location.getSingle(event)) == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            world = (World)Bukkit.getWorlds().get(0);
        }
        ArrayList<RayTraceResult> results = new ArrayList<RayTraceResult>();
        for (Vector vector : (Vector[])this.vectors.getArray(event)) {
            if (vector.isZero()) {
                this.error("A ray trace may not trace along a zero vector");
                continue;
            }
            RayTraceResult rayTraceResult = world.rayTrace((Position)location, vector, maxDistance, FluidCollisionMode.NEVER, this.ignore, raySize, EntityUtils.filter(null, ignoredEntities), ExprRayTraceFromLocation.filteredBlocks(ignoredBlocks));
            results.add(rayTraceResult);
        }
        return results.toArray(new RayTraceResult[0]);
    }

    public boolean isSingle() {
        return this.vectors.isSingle();
    }

    @NotNull
    public Class<? extends RayTraceResult> getReturnType() {
        return RayTraceResult.class;
    }

    public static Predicate<Block> filteredBlocks(Object[] ignoredBlocks) {
        return block -> {
            if (ignoredBlocks == null) {
                return true;
            }
            for (Object ignoredBlock : ignoredBlocks) {
                Block block1;
                if (ignoredBlock instanceof Block && block == (block1 = (Block)ignoredBlock)) {
                    return false;
                }
                if (!(ignoredBlock instanceof ItemType)) continue;
                ItemType itemType = (ItemType)ignoredBlock;
                if (block.getType() != itemType.getMaterial()) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String max = this.maxDistance != null ? " with max distance " + this.maxDistance.toString(e, d) : "";
        String size = this.raySize != null ? " with ray size " + this.raySize.toString(e, d) : "";
        String ignore = this.ignore ? " while ignoring passable blocks" : "";
        String ignoredEntities = this.ignoredEntities != null ? " while ignoring " + this.ignoredEntities.toString(e, d) : "";
        String ignoredBlocks = this.ignoredBlocks != null ? " while going through " + this.ignoredBlocks.toString(e, d) : "";
        return "ray trace from " + this.location.toString(e, d) + " along " + this.vectors.toString(e, d) + max + size + ignore + ignoredEntities + ignoredBlocks;
    }

    static {
        Skript.registerExpression(ExprRayTraceFromLocation.class, RayTraceResult.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"ray[ ]trace from %location% along %vectors% [with max distance %-number%] [with ray size %-number%] [ignore:while ignoring passable blocks] [while ignoring %-entities/entitydatas%] [while going through %-blocks/itemtypes%]"});
    }
}

