/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;

@Name(value="Recipe - Remove")
@Description(value={"Remove a recipe from your server. Recipes can be removed at any time ", "but it is best to do so during a server load event. If a recipe is removed whilst a player is online ", "it will still show up in their recipe book, but they will not be able to craft it. If need be, you can get ", "a list of all recipes by simply typing \"/minecraft:recipe give YourName \" in game.", "You can remove Minecraft recipes, custom recipes and recipes from other plugins. Requires MC 1.13+"})
@Examples(value={"remove mc recipe \"acacia_boat\"", "remove minecraft recipe \"cooked_chicken_from_campfire_cooking\"", "remove recipe \"minecraft:diamond_sword\"", "remove all minecraft recipes", "remove all recipes", "remove custom recipe \"my_recipe\"", "remove recipe \"another_recipe\"", "remove recipe \"some_plugin:some_recipe\""})
@Since(value={"1.0.0"})
public class EffRemoveRecipe
extends Effect {
    private Expression<String> recipes;
    private boolean all;
    private boolean minecraft;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.all = pattern == 1;
        this.minecraft = parseResult.mark == 1;
        this.recipes = pattern == 0 ? exprs[0] : null;
        return true;
    }

    protected void execute(Event event) {
        if (this.all) {
            if (this.minecraft) {
                RecipeUtil.removeAllMCRecipes();
                if (SkBee.isDebug()) {
                    RecipeUtil.log("&aRemoving all Minecraft recipes.");
                }
            } else {
                Bukkit.clearRecipes();
                if (SkBee.isDebug()) {
                    RecipeUtil.log("&aRemoving all recipes.");
                }
            }
            return;
        }
        for (String recipe : (String[])this.recipes.getAll(event)) {
            NamespacedKey key = Util.getNamespacedKey(recipe, false);
            if (key == null) continue;
            Bukkit.removeRecipe((NamespacedKey)key);
            if (!SkBee.isDebug()) continue;
            RecipeUtil.log("&aRemoving recipe: " + recipe);
        }
    }

    public String toString(Event e, boolean d) {
        if (this.all) {
            return "remove all minecraft recipes";
        }
        if (this.minecraft) {
            return "remove minecraft recipes " + this.recipes.toString(e, d);
        }
        return "remove custom recipes " + this.recipes.toString(e, d);
    }

    static {
        Skript.registerEffect(EffRemoveRecipe.class, (String[])new String[]{"remove [(custom|mc|minecraft)] recipe[s] %strings%", "remove all [(1:(mc|minecraft))] recipe[s]"});
    }
}

