/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - CookTime")
@Description(value={"Get the cooktime of a cooking recipes."})
@Examples(value={"set {_time} to cooktime of recipe with id \"minecraft:cooked_chicken\""})
@Since(value={"2.18.0"})
public class ExprRecipeCookTime
extends SimpleExpression<Timespan> {
    private Expression<String> key;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[0];
        return true;
    }

    @Nullable
    protected Timespan[] get(Event event) {
        ArrayList<Timespan> cookTimes = new ArrayList<Timespan>();
        for (String key : (String[])this.key.getArray(event)) {
            Recipe recipe;
            NamespacedKey namespacedKey = Util.getNamespacedKey(key, false);
            if (namespacedKey == null || !((recipe = Bukkit.getRecipe((NamespacedKey)namespacedKey)) instanceof CookingRecipe)) continue;
            CookingRecipe cookingRecipe = (CookingRecipe)recipe;
            cookTimes.add(new Timespan(Timespan.TimePeriod.TICK, (long)cookingRecipe.getCookingTime()));
        }
        return cookTimes.toArray(new Timespan[0]);
    }

    public boolean isSingle() {
        return this.key.isSingle();
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "cook time of recipe " + this.key.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprRecipeCookTime.class, Timespan.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"cook[ ]time of recipe[s] [with id[s]] %strings%"});
    }
}

