/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Experience")
@Description(value={"Get the experience gained from a cooking recipe."})
@Examples(value={"set {_time} to experience of recipe with id \"minecraft:cooked_chicken\""})
@Since(value={"2.18.0"})
public class ExprRecipeExperience
extends SimpleExpression<Number> {
    private Expression<String> key;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[0];
        return true;
    }

    @Nullable
    protected Number[] get(Event event) {
        ArrayList<Float> exp = new ArrayList<Float>();
        for (String key : (String[])this.key.getArray(event)) {
            Recipe recipe;
            NamespacedKey namespacedKey = Util.getNamespacedKey(key, false);
            if (namespacedKey == null || !((recipe = Bukkit.getRecipe((NamespacedKey)namespacedKey)) instanceof CookingRecipe)) continue;
            CookingRecipe cookingRecipe = (CookingRecipe)recipe;
            exp.add(Float.valueOf(cookingRecipe.getExperience()));
        }
        return exp.toArray(new Number[0]);
    }

    public boolean isSingle() {
        return this.key.isSingle();
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "experience of recipe " + this.key.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprRecipeExperience.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(experience|[e]xp) of recipe[s] [with id[s]] %strings%"});
    }
}

