/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.recipe.CookingRecipeType;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Recipe - Register Cooking Recipe")
@Description(value={"This section allows you to register any cooking recipe and define special properties.", "\n`id` = The ID for your recipe. This is used for recipe discovery and Minecraft's /recipe command.", "\n`result` = The resulting ItemStack of this recipe.", "\n`input` = The item the recipe requires as an input to output the result (Accepts an ItemStack or RecipeChoice) (Required).", "\n`cooktime` = How long the recipe will take to finish cooking before result is given (Optional).", "\n`experience` = The amount of experience gained when the recipe is finished cooking (Optional).", "Default cook times are, furnace = 10 seconds, smoking/blasting = 5 seconds and campfire = 30 seconds.", "\n`group` = You can define a group in which all recipes under this are sorted together in the recipe book (Optional).", "Examples of this in game are beds and wood types.", "\n`category` = Which category in the recipe book this recipe should appear within (Optional 1.19.4+).", "Valid category types are \"food\", \"blocks\", \"misc\", if no category is defined it defaults to \"misc\"."})
@Examples(value={"register new furnace recipe:", "\tid: \"sieve:gravel_to_sand\"", "\tresult: sand", "\tinput: gravel", "\tgroup: \"sieve\"", "\tcooktime: 1 minecraft day # 20 minutes", "\texperience: 6", "\tcategory: \"blocks\"", "", "register new campfire recipe:", "\tid: \"sieve:cobblestone_to_gravel\"", "\tresult: gravel", "\tinput: cobblestone", "\tgroup: \"sieve\"", "\tcategory: \"blocks\"", "", "register new smoking recipe:", "\tid: \"chef:beef_jerky\"", "\tresult: cooked mutton named \"&oBeef&r Jerky\"", "\tinput: rotten flesh", "\tcategory: \"food\"", "", "register a new blasting recipe:", "\tid: \"firery_sword\"", "\tresult: diamond sword of fire aspect named \"Flaming Sword\"", "\tinput: diamond sword"})
@Since(value={"3.0.0"})
public class SecRecipeCooking
extends Section {
    private static final EntryValidator VALIDATOR;
    private static final Map<String, CookingBookCategory> CATEGORY_MAP;
    private CookingRecipeType recipeType;
    private Expression<String> id;
    private Expression<ItemStack> result;
    private Expression<RecipeChoice> input;
    private Expression<String> category;
    private Expression<String> group;
    private Expression<Timespan> cookTime;
    private Expression<Number> experience;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.recipeType = CookingRecipeType.values()[parseResult.mark];
        this.id = (Expression)container.getOptional("id", false);
        if (this.id == null) {
            return false;
        }
        this.result = (Expression)container.getOptional("result", false);
        if (this.result == null) {
            return false;
        }
        this.input = (Expression)container.getOptional("input", false);
        if (this.input == null) {
            return false;
        }
        this.category = (Expression)container.getOptional("category", false);
        this.group = (Expression)container.getOptional("group", false);
        this.cookTime = (Expression)container.getOptional("cooktime", false);
        this.experience = (Expression)container.getOptional("experience", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        this.execute(event);
        return super.walk(event, false);
    }

    private void execute(Event event) {
        String recipeGroup;
        String category;
        FurnaceRecipe recipe;
        String recipeId = (String)this.id.getSingle(event);
        if (recipeId == null) {
            this.error("Missing id");
            return;
        }
        NamespacedKey namespacedKey = Util.getNamespacedKey(recipeId, false);
        ItemStack result = (ItemStack)this.result.getSingle(event);
        RecipeChoice input = (RecipeChoice)this.input.getSingle(event);
        int cookTime = this.recipeType.getCookTime();
        if (this.cookTime != null) {
            Timespan timespan = (Timespan)this.cookTime.getSingle(event);
            if (timespan != null) {
                cookTime = (int)timespan.getAs(Timespan.TimePeriod.TICK);
            } else {
                this.warning("Invalid cooktime, defaulting to recipe default: " + String.valueOf(new Timespan(Timespan.TimePeriod.TICK, (long)cookTime)));
            }
        }
        float experience = 0.0f;
        if (this.experience != null) {
            Number num = (Number)this.experience.getSingle(event);
            if (num != null) {
                experience = num.floatValue();
            } else {
                this.warning("Invalid experience, defaulting to 0");
            }
        }
        if (namespacedKey == null) {
            this.error("Invalid id: " + recipeId);
            return;
        }
        if (result == null || !result.getType().isItem() || result.getType().isAir()) {
            this.error("Invalid result: " + String.valueOf(result));
            return;
        }
        if (input == null) {
            this.error("Invalid input: " + this.input.toString(event, true));
            return;
        }
        switch (this.recipeType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FURNACE: {
                FurnaceRecipe furnaceRecipe = new FurnaceRecipe(namespacedKey, result, input, experience, cookTime);
                break;
            }
            case SMOKING: {
                FurnaceRecipe furnaceRecipe = new SmokingRecipe(namespacedKey, result, input, experience, cookTime);
                break;
            }
            case BLASTING: {
                FurnaceRecipe furnaceRecipe = new BlastingRecipe(namespacedKey, result, input, experience, cookTime);
                break;
            }
            case CAMPFIRE: {
                FurnaceRecipe furnaceRecipe = recipe = new CampfireRecipe(namespacedKey, result, input, experience, cookTime);
            }
        }
        if (this.category != null && (category = (String)this.category.getSingle(event)) != null && CATEGORY_MAP.containsKey(category.toLowerCase(Locale.ROOT))) {
            recipe.setCategory(CATEGORY_MAP.get(category.toLowerCase(Locale.ROOT)));
        }
        String string = recipeGroup = this.group != null ? (String)this.group.getSingle(event) : null;
        if (recipeGroup != null && !recipeGroup.isBlank()) {
            recipe.setGroup(recipeGroup);
        }
        Bukkit.removeRecipe((NamespacedKey)namespacedKey);
        Bukkit.addRecipe((Recipe)recipe);
        RecipeUtil.logCookingRecipe(recipe);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "register a new " + this.recipeType.toString().toLowerCase(Locale.ROOT) + " recipe";
    }

    static {
        CATEGORY_MAP = new HashMap<String, CookingBookCategory>();
        SimpleEntryValidator builder = SimpleEntryValidator.builder();
        builder.addRequiredEntry("id", String.class);
        builder.addRequiredEntry("result", ItemStack.class);
        builder.addRequiredEntry("input", RecipeChoice.class);
        builder.addOptionalEntry("group", String.class);
        builder.addOptionalEntry("cooktime", Timespan.class);
        builder.addOptionalEntry("experience", Number.class);
        if (RecipeUtil.HAS_CATEGORY) {
            builder.addOptionalEntry("category", String.class);
            for (CookingBookCategory category : CookingBookCategory.values()) {
                CATEGORY_MAP.put(category.toString().toLowerCase(Locale.ROOT), category);
            }
        }
        VALIDATOR = builder.build();
        Skript.registerSection(SecRecipeCooking.class, (String[])new String[]{"register [a] [new] (furnace|1:smoking|2:blasting|3:campfire) recipe"});
    }
}

