/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Recipe - Register Smithing Recipe")
@Description(value={"This section allows you to register a smithing transform recipe, define the output as well as the template, ", "base and addition items. Requires MC 1.20+", "\n`id` = The ID for your recipe.", "\n`result` = The resulting ItemStack of this recipe.", "\n`template` = Represents the first slot in the smithing inventory (Accepts an ItemStack or RecipeChoice).", "\n`base` = Represents the second slot in the smithing inventory (Accepts an ItemStack or RecipeChoice).", "\n`addition` = Represents the third slot in the smithing inventory (Optional).", "\n`copynbt` = Represents whether to copy the nbt from the input base item to the output, default = true (Requires PaperMC) (Optional)."})
@Examples(value={"on load:", "\tregister smithing transform recipe:", "\t\tid: \"test:smithing\"", "\t\tresult: emerald of unbreaking named \"&cFire Stone\" with all item flags", "\t\ttemplate: paper named \"&cFire Paper\"", "\t\tbase: diamond", "\t\taddition: blaze powder"})
@Since(value={"3.0.0"})
public class SecRecipeSmithing
extends Section {
    public static final boolean HAS_NBT_METHOD = Skript.methodExists(SmithingRecipe.class, (String)"willCopyNbt", (Class[])new Class[0]);
    private static final EntryValidator VALIDATOR;
    private Expression<String> id;
    private Expression<ItemStack> result;
    private Expression<RecipeChoice> template;
    private Expression<RecipeChoice> base;
    private Expression<RecipeChoice> addition;
    private Expression<Boolean> copyNbt;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.id = (Expression)container.getOptional("id", false);
        if (this.id == null) {
            return false;
        }
        this.result = (Expression)container.getOptional("result", false);
        if (this.result == null) {
            return false;
        }
        this.template = (Expression)container.getOptional("template", false);
        if (this.template == null) {
            return false;
        }
        this.base = (Expression)container.getOptional("base", false);
        if (this.base == null) {
            return false;
        }
        this.addition = (Expression)container.getOptional("addition", false);
        this.copyNbt = (Expression)container.getOptional("copynbt", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        this.execute(event);
        return super.walk(event, false);
    }

    private void execute(Event event) {
        SmithingTransformRecipe recipe;
        RecipeChoice addition;
        String recipeId = (String)this.id.getSingle(event);
        if (recipeId == null) {
            this.error("Missing id");
            return;
        }
        NamespacedKey key = Util.getNamespacedKey(recipeId, false);
        ItemStack result = (ItemStack)this.result.getSingle(event);
        RecipeChoice base = this.base != null ? RecipeUtil.getRecipeChoice(this.base.getSingle(event)) : null;
        RecipeChoice template = this.template != null ? RecipeUtil.getRecipeChoice(this.template.getSingle(event)) : null;
        RecipeChoice recipeChoice = addition = this.addition != null ? RecipeUtil.getRecipeChoice(this.addition.getSingle(event)) : null;
        if (key == null) {
            this.error("Invalid id: " + recipeId);
            return;
        }
        if (result == null || !result.getType().isItem() || result.getType().isAir()) {
            this.error("Missing/Invalid recipe result: " + String.valueOf(result));
            return;
        }
        if (base == null) {
            this.error("Invalid/Missing recipe base: " + this.toString(event, true));
            return;
        }
        if (template == null) {
            this.error("Invalid/Missing recipe template: " + this.toString(event, true));
            return;
        }
        if (addition == null) {
            addition = RecipeChoice.empty();
        }
        if (HAS_NBT_METHOD) {
            boolean copynbt = true;
            if (this.copyNbt != null) {
                copynbt = Boolean.TRUE.equals(this.copyNbt.getSingle(event));
            }
            recipe = new SmithingTransformRecipe(key, result, template, base, addition, copynbt);
        } else {
            recipe = new SmithingTransformRecipe(key, result, template, base, addition);
        }
        Bukkit.removeRecipe((NamespacedKey)key);
        Bukkit.addRecipe((Recipe)recipe);
        RecipeUtil.logSmithingRecipe(recipe);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "register smithing recipe";
    }

    static {
        SimpleEntryValidator builder = SimpleEntryValidator.builder();
        builder.addRequiredEntry("id", String.class);
        builder.addRequiredEntry("result", ItemStack.class);
        builder.addRequiredEntry("template", RecipeChoice.class);
        builder.addRequiredEntry("base", RecipeChoice.class);
        builder.addOptionalEntry("addition", RecipeChoice.class);
        builder.addOptionalEntry("copynbt", Boolean.class);
        Skript.registerSection(SecRecipeSmithing.class, (String[])new String[]{"register [a] [new] smithing [transform] recipe"});
        VALIDATOR = builder.build();
    }
}

