/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.registry.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.registry.KeyUtils;
import com.shanebeestudios.skbee.api.registry.RegistryUtils;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import net.kyori.adventure.key.Key;
import org.bukkit.Keyed;
import org.bukkit.Registry;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Registry - TagKey from Registry")
@Description(value={"Get a TagKey from a registry."})
@Examples(value={"set {_tagkey} to tag key \"minecraft:wool\" from block registry", "set {_tagkey} to tag key \"my_pack:cool_enchantments\" from enchantment registry", "set {_tagkey} to item registry tag key \"minecraft:swords\""})
@Since(value={"3.8.0"})
public class ExprRegistryTagKeyFrom
extends SimpleExpression<TagKey> {
    private Expression<String> key;
    private Expression<RegistryKey<Keyed>> registryKey;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[matchedPattern];
        this.registryKey = exprs[matchedPattern ^ 1];
        return true;
    }

    protected TagKey<?> @Nullable [] get(Event event) {
        String keyString = (String)this.key.getSingle(event);
        RegistryKey registryKey = (RegistryKey)this.registryKey.getSingle(event);
        if (keyString == null || registryKey == null) {
            return null;
        }
        Key key = KeyUtils.getKey(keyString);
        if (key == null) {
            return null;
        }
        TagKey tagKey = TagKey.create((RegistryKey)registryKey, (Key)key);
        Registry registry = RegistryUtils.getRegistry(registryKey);
        if (registry.hasTag(tagKey)) {
            return new TagKey[]{tagKey};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends TagKey> getReturnType() {
        return TagKey.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return new SyntaxStringBuilder(e, d).append(new Object[]{"tag key", this.key, "from", this.registryKey}).toString();
    }

    static {
        Skript.registerExpression(ExprRegistryTagKeyFrom.class, TagKey.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"tag key %string% from %registrykey%", "%registrykey% tag key %string%"});
    }
}

