/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.registry.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.registry.RegistryHolder;
import com.shanebeestudios.skbee.api.registry.RegistryHolders;
import io.papermc.paper.registry.RegistryKey;
import java.lang.reflect.Array;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Registry - Registry Values")
@Description(value={"Get all values from a registry."})
@Examples(value={"set {_biomes::*} to registry values of biome registry", "loop registry values of item registry:"})
@Since(value={"3.8.0"})
public class ExprRegistryValues
extends SimpleExpression<Object> {
    private Expression<RegistryKey<?>> registryKey;
    private Class<?> returnType = null;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.registryKey = exprs[0];
        Expression<RegistryKey<?>> expression = this.registryKey;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            this.returnType = RegistryHolders.getRegistryHolder((RegistryKey)literal.getSingle()).getReturnType();
        }
        return true;
    }

    protected Object @Nullable [] get(Event event) {
        RegistryKey registryKey = (RegistryKey)this.registryKey.getSingle(event);
        if (registryKey == null) {
            return null;
        }
        RegistryHolder registryHolder = RegistryHolders.getRegistryHolder(registryKey);
        if (this.returnType == null) {
            this.returnType = registryHolder.getReturnType();
        }
        List<Object> values = registryHolder.getValues();
        return values.toArray((Object[])Array.newInstance(this.returnType, values.size()));
    }

    public boolean isSingle() {
        return false;
    }

    public Class<?> getReturnType() {
        if (this.returnType == null) {
            return Object.class;
        }
        return this.returnType;
    }

    public String toString(Event e, boolean d) {
        return "registry values of " + this.registryKey.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprRegistryValues.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"registry values of %registrykey%"});
    }
}

