/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.scoreboard.TeamUtils;
import com.shanebeestudios.skbee.api.skript.base.Condition;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - Is Registered")
@Description(value={"Check if a team is registered.", "Optionally check for a specific scoreboard (will default to main scoreboard)."})
@Examples(value={"if team \"a-team\" is registered:", "if team \"b-team\" of player's scoreboard is registered:"})
@Since(value={"2.17.0"})
public class CondTeamRegistered
extends Condition {
    private Expression<String> teams;
    private Expression<Scoreboard> scoreboard;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(matchedPattern == 1);
        this.teams = exprs[0];
        this.scoreboard = exprs[1];
        return true;
    }

    public boolean check(Event event) {
        Scoreboard scoreboard = (Scoreboard)this.scoreboard.getSingle(event);
        if (scoreboard == null) {
            return false;
        }
        return this.teams.check(event, name -> TeamUtils.isRegistered(name, scoreboard), this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String plural = this.teams.isSingle() ? " is" : " are";
        String neg = this.isNegated() ? " not" : "";
        return "team " + this.teams.toString(e, d) + plural + neg + " registered";
    }

    static {
        Skript.registerCondition(CondTeamRegistered.class, (String[])new String[]{"team[s] [named|with id] %strings% [(of|for) %scoreboard%] (is|are) registered", "team[s] [named] %strings% [(of|for) %scoreboard%] (isn't|is not|are not|aren't) registered"});
    }
}

