/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.scoreboard.ScoreboardUtils;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Scoreboard of Player")
@Description(value={"Get/set the scoreboard of players.", "By default all players share the same main scoreboard unless given a new scoreboard.", "Do note that custom scoreboards are not persistent.", "Reset will reset the player's scoreboard back to the main server scoreboard."})
@Examples(value={"set {_scoreboard} to scoreboard of player", "set scoreboard of player to a new scoreboard", "set scoreboard of player to the vanilla scoreboard", "reset scoreboard of player"})
@Since(value={"3.9.0"})
public class ExprScoreboardPlayer
extends SimplePropertyExpression<Player, Scoreboard> {
    @Nullable
    public Scoreboard convert(Player player) {
        return player.getScoreboard();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Scoreboard.class});
        }
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Scoreboard sb;
        Object object;
        Scoreboard scoreboard = delta != null && (object = delta[0]) instanceof Scoreboard ? (sb = (Scoreboard)object) : null;
        for (Player player : (Player[])this.getExpr().getArray(event)) {
            if (mode == Changer.ChangeMode.SET) {
                if (scoreboard == null) continue;
                player.setScoreboard(scoreboard);
                continue;
            }
            if (mode != Changer.ChangeMode.RESET) continue;
            player.setScoreboard(ScoreboardUtils.getMainScoreboard());
        }
    }

    protected String getPropertyName() {
        return "scoreboard";
    }

    public Class<? extends Scoreboard> getReturnType() {
        return Scoreboard.class;
    }

    static {
        ExprScoreboardPlayer.register(ExprScoreboardPlayer.class, Scoreboard.class, (String)"scoreboard", (String)"players");
    }
}

