/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - Options")
@Description(value={"Represents an option for a team."})
@Examples(value={"set team option name tag visibility of team named \"a-team\" to never", "set team option collision rule of team of player to always"})
@Since(value={"1.16.0"})
public class ExprTeamOption
extends SimpleExpression<Team.OptionStatus> {
    private Expression<Team.Option> teamOption;
    private Expression<Team> teams;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.teamOption = exprs[matchedPattern];
        this.teams = exprs[matchedPattern == 0 ? 1 : 0];
        return true;
    }

    protected Team.OptionStatus[] get(Event event) {
        Team.Option teamOption = (Team.Option)this.teamOption.getSingle(event);
        if (teamOption == null) {
            return null;
        }
        ArrayList<Team.OptionStatus> statuses = new ArrayList<Team.OptionStatus>();
        for (Team team : (Team[])this.teams.getArray(event)) {
            statuses.add(team.getOption(teamOption));
        }
        return statuses.toArray(new Team.OptionStatus[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Team.OptionStatus.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Team.Option teamOption = (Team.Option)this.teamOption.getSingle(event);
        Team.OptionStatus optionStatus = (Team.OptionStatus)delta[0];
        if (teamOption == null || optionStatus == null) {
            return;
        }
        for (Team team : (Team[])this.teams.getArray(event)) {
            team.setOption(teamOption, optionStatus);
        }
    }

    public boolean isSingle() {
        return this.teams.isSingle();
    }

    @NotNull
    public Class<? extends Team.OptionStatus> getReturnType() {
        return Team.OptionStatus.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "team option " + this.teamOption.toString(e, d) + " of " + this.teams.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprTeamOption.class, Team.OptionStatus.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"team option %teamoption% of %teams%", "%teams%'[s] team option %teamoption%"});
    }
}

