/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - State")
@Description(value={"Represents the friendly fire and can see friendly invisibles states of a team."})
@Examples(value={"set allow friendly fire team state of team named \"a-team\" to true", "set can see friendly invisbles team state of team of player to false"})
@Since(value={"1.16.0"})
public class ExprTeamState
extends SimplePropertyExpression<Team, Boolean> {
    private int pattern;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Boolean convert(Team team) {
        return this.pattern == 0 ? team.allowFriendlyFire() : team.canSeeFriendlyInvisibles();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        boolean state = (Boolean)delta[0];
        for (Team team : (Team[])this.getExpr().getArray(event)) {
            if (this.pattern == 0) {
                team.setAllowFriendlyFire(state);
                continue;
            }
            team.setCanSeeFriendlyInvisibles(state);
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        String state = this.pattern == 0 ? "allow friendly fire" : "can see friendly invisibles";
        return state + " team state";
    }

    static {
        ExprTeamState.register(ExprTeamState.class, Boolean.class, (String)"(allow friendly fire|1:can see friendly invisibles) team state", (String)"teams");
    }
}

