/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.type;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.api.reflection.ReflectionUtils;
import com.shanebeestudios.skbee.api.scoreboard.ScoreboardUtils;
import com.shanebeestudios.skbee.api.scoreboard.TeamUtils;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.EnumWrapper;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Types {
    private static final List<Criteria> CRITERIAS = new ArrayList<Criteria>();

    static {
        Class<?> craftCriteriaClass = ReflectionUtils.getOBCClass("scoreboard.CraftCriteria");
        assert (craftCriteriaClass != null);
        Object defaults = ReflectionUtils.getField("DEFAULTS", craftCriteriaClass, null);
        Map map = (Map)defaults;
        assert (map != null);
        CRITERIAS.addAll(map.values());
        if (Classes.getExactClassInfo(Scoreboard.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Scoreboard.class, "scoreboard").user(new String[]{"scoreboards?"}).name("Scoreboard").description(new String[]{"Represents the vanilla scoreboard of the server/players.", "This can be the main server scoreboard, or a custom scoreboard.", "Do note custom scoreboards are not persistent (do not save to the server).", "Multiple players can share a custom scoreboard.", "See [**Scoreboard**](https://minecraft.wiki/w/Scoreboard) on McWiki for more info."}).since("3.9.0").defaultExpression((DefaultExpression)new SimpleLiteral((Object)ScoreboardUtils.getMainScoreboard(), true)).parser((Parser)new Parser<Scoreboard>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                public String toString(Scoreboard scoreboard, int flags) {
                    String name = scoreboard.equals((Object)ScoreboardUtils.getMainScoreboard()) ? "Main Scoreboard" : "Custom Scoreboard";
                    return name;
                }

                public String toVariableNameString(Scoreboard scoreboard) {
                    return this.toString(scoreboard, 0);
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'scoreboard' already.", new Object[0]);
            Util.logLoading("You may have to use their Scoreboards in SkBee's scoreboard elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Objective.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Objective.class, "objective").user(new String[]{"objectives?"}).name("Scoreboard - Objective").description(new String[]{"Represents an objective in a scoreboard.", "When deleting, the objective will be unregistered.", "See [**Objectives**](https://minecraft.wiki/w/Scoreboard#Objectives) on McWiki for more info."}).since("2.6.0").supplier(() -> Bukkit.getScoreboardManager().getMainScoreboard().getObjectives().iterator()).parser((Parser)new Parser<Objective>(){

                public boolean canParse(@NotNull ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(Objective objective, int flags) {
                    return "objective '" + objective.getName() + "' with criteria '" + objective.getTrackedCriteria().getName() + "'";
                }

                @NotNull
                public String toVariableNameString(Objective objective) {
                    return "objective{name=" + objective.getName() + "}";
                }
            }).changer((Changer)new Changer<Objective>(){

                @Nullable
                public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.DELETE) {
                        return (Class[])CollectionUtils.array((Object[])new Class[]{Objective.class});
                    }
                    return null;
                }

                public void change(Objective[] what, @Nullable Object[] delta, Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.DELETE) {
                        for (Objective objective : what) {
                            objective.unregister();
                        }
                    }
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'objective' already.", new Object[0]);
            Util.logLoading("You may have to use their Objectives in SkBee's scoreboard elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Criteria.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Criteria.class, "criteria").user(new String[]{"criterias?"}).name("Scoreboard - Criteria").description(new String[]{"Represents a criteria for a scoreboard objective.", "See [**Criteria**](https://minecraft.wiki/w/Scoreboard#Criteria) on McWiki for more info."}).since("2.6.0").supplier(() -> CRITERIAS.stream().sorted(Comparator.comparing(Criteria::getName)).iterator()).parser((Parser)new Parser<Criteria>(){

                public boolean canParse(@NotNull ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(Criteria criteria, int flags) {
                    return "criteria '" + criteria.getName() + "'";
                }

                @NotNull
                public String toVariableNameString(Criteria o) {
                    return "criteria{name=" + o.getName() + "}";
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'criteria' already.", new Object[0]);
            Util.logLoading("You may have to use their Criterias in SkBee's scoreboard elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(RenderType.class) == null) {
            EnumWrapper<RenderType> RENDER_ENUM = new EnumWrapper<RenderType>(RenderType.class);
            Classes.registerClass((ClassInfo)RENDER_ENUM.getClassInfo("rendertype").user(new String[]{"render ?types?"}).name("Scoreboard - Objective Render Type").description(new String[]{"Controls the way in which an Objective is rendered client side."}).since("2.6.0"));
        }
        if (Classes.getExactClassInfo(DisplaySlot.class) == null) {
            EnumWrapper<DisplaySlot> DISPLAY_ENUM = new EnumWrapper<DisplaySlot>(DisplaySlot.class);
            Classes.registerClass((ClassInfo)DISPLAY_ENUM.getClassInfo("displayslot").user(new String[]{"display ?slots?"}).name("Scoreboard - Objective Display Slot").description(new String[]{"Locations for displaying objectives to the player"}).since("2.6.0"));
        }
        if (Classes.getExactClassInfo(Team.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Team.class, "team").user(new String[]{"teams?"}).name("Team").description(new String[]{"Represents a scoreboard team. Teams can be deleted (unregistered).", "Players, entities and strings can be added to and removed from teams.", "Teams off the main scoreboard cannot be serialized/saved to variables.", "See [**Teams**](https://minecraft.wiki/w/Scoreboard#Teams) on McWiki for more info."}).examples(new String[]{"add all players to team of player", "add all players to team named \"a-team\"", "remove all entities from team named \"the-mobs\"", "delete team named \"z-team\""}).since("1.16.0, 2.11.0 (add/remove/delete)").parser((Parser)new Parser<Team>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(Team team, int flags) {
                    return "Team[" + team.getName() + "]";
                }

                @NotNull
                public String toVariableNameString(Team team) {
                    return this.toString(team, 0);
                }
            }).serializer((Serializer)new Serializer<Team>(){

                @NotNull
                public Fields serialize(Team team) {
                    Fields fields = new Fields();
                    try {
                        if (team == null) {
                            Skript.error((String)"Team is null!");
                        } else if (!team.getScoreboard().equals((Object)ScoreboardUtils.getMainScoreboard())) {
                            Skript.error((String)("Team '" + team.getName() + "' is off the main scoreboard and cannot be serialized!"));
                        } else {
                            fields.putObject("name", (Object)team.getName());
                        }
                    }
                    catch (IllegalStateException ignore) {
                        Skript.error((String)"Team was unregistered");
                    }
                    return fields;
                }

                public void deserialize(Team o, Fields f) {
                }

                protected Team deserialize(@NotNull Fields fields) throws StreamCorruptedException {
                    if (!fields.contains("name")) {
                        throw new StreamCorruptedException("Team name field is missing");
                    }
                    String name = (String)fields.getObject("name", String.class);
                    return TeamUtils.getTeam(name, ScoreboardUtils.getMainScoreboard());
                }

                public boolean mustSyncDeserialization() {
                    return true;
                }

                protected boolean canBeInstantiated() {
                    return false;
                }
            }).changer((Changer)new Changer<Team>(){

                @Nullable
                public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                    if (mode == Changer.ChangeMode.DELETE) {
                        return (Class[])CollectionUtils.array((Object[])new Class[0]);
                    }
                    if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
                        return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer[].class, Player[].class, Entity[].class, String[].class});
                    }
                    return null;
                }

                public void change(Team[] teams, @Nullable Object[] delta, Changer.ChangeMode mode) {
                    block7: {
                        ArrayList<String> names;
                        block8: {
                            block6: {
                                if (mode != Changer.ChangeMode.DELETE) break block6;
                                for (Team team : teams) {
                                    team.unregister();
                                }
                                break block7;
                            }
                            names = new ArrayList<String>();
                            for (Object object : delta) {
                                if (object instanceof OfflinePlayer) {
                                    OfflinePlayer player = (OfflinePlayer)object;
                                    names.add(player.getName());
                                    continue;
                                }
                                if (object instanceof Entity) {
                                    Entity entity = (Entity)object;
                                    names.add(entity.getUniqueId().toString());
                                    continue;
                                }
                                if (!(object instanceof String)) continue;
                                String string = (String)object;
                                names.add(string);
                            }
                            if (mode != Changer.ChangeMode.ADD) break block8;
                            for (Team team : teams) {
                                names.forEach(arg_0 -> ((Team)team).addEntry(arg_0));
                            }
                            break block7;
                        }
                        if (mode != Changer.ChangeMode.REMOVE) break block7;
                        for (Team team : teams) {
                            names.forEach(arg_0 -> ((Team)team).removeEntry(arg_0));
                        }
                    }
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'team' already.", new Object[0]);
            Util.logLoading("You may have to use their Team in SkBee's scoreboard elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Team.Option.class) == null) {
            EnumWrapper<Team.Option> TEAM_OPTIONS = new EnumWrapper<Team.Option>(Team.Option.class);
            Classes.registerClass((ClassInfo)TEAM_OPTIONS.getClassInfo("teamoption").user(new String[]{"team ?options?"}).name("Team - Option").description(new String[]{"Represents an option for a team."}).since("1.16.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'teamoption' already.", new Object[0]);
            Util.logLoading("You may have to use their Team Option in SkBee's scoreboard elements.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Team.OptionStatus.class) == null) {
            EnumWrapper<Team.OptionStatus> TEAM_OPTION_STATUS = new EnumWrapper<Team.OptionStatus>(Team.OptionStatus.class);
            Classes.registerClass((ClassInfo)TEAM_OPTION_STATUS.getClassInfo("teamoptionstatus").user(new String[]{"team ?option ?status"}).name("Team - Option Status").description(new String[]{"Represents an option status for a team option"}).since("1.16.0"));
        } else {
            Util.logLoading("It looks like another addon registered 'teamoptionstatus' already.", new Object[0]);
            Util.logLoading("You may have to use their Team Option Status in SkBee's scoreboard elements.", new Object[0]);
        }
    }
}

