/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.statistic.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Statistic - Get/Set")
@Description(value={"Represents the statistic of a Player. You can get, set, add, remove or reset stats."})
@Examples(value={"set {_s} to kill entity stat using sheep for player", "set kill entity stat using zombie for player to 10", "add 10 to mine block stat using diamond ore for player", "remove 10 from chest opened stat for player", "reset mob kills stat for player"})
@Since(value={"1.17.0"})
public class ExprPlayerStatistic
extends SimpleExpression<Number> {
    private Expression<Statistic> statistic;
    private Expression<OfflinePlayer> player;
    private Expression<Object> qualifier;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.statistic = exprs[0];
        this.qualifier = exprs[1];
        this.player = exprs[2];
        return true;
    }

    @Nullable
    protected Number[] get(Event event) {
        Object qualifier;
        ArrayList<Integer> stats = new ArrayList<Integer>();
        Statistic statistic = (Statistic)this.statistic.getSingle(event);
        Object object = qualifier = this.qualifier != null ? this.qualifier.getSingle(event) : null;
        if (statistic == null) {
            return null;
        }
        for (OfflinePlayer offlinePlayer : (OfflinePlayer[])this.player.getArray(event)) {
            stats.add(this.getStat(offlinePlayer, statistic, qualifier));
        }
        return stats.toArray(new Number[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int change = delta != null && delta[0] instanceof Number ? ((Number)delta[0]).intValue() : 0;
        Object qualifier = this.qualifier != null ? this.qualifier.getSingle(event) : null;
        Statistic statistic = (Statistic)this.statistic.getSingle(event);
        if (statistic == null) {
            return;
        }
        for (OfflinePlayer offlinePlayer : (OfflinePlayer[])this.player.getArray(event)) {
            int changeValue = change;
            switch (mode) {
                case ADD: {
                    changeValue += this.getStat(offlinePlayer, statistic, qualifier);
                    break;
                }
                case REMOVE: {
                    changeValue = this.getStat(offlinePlayer, statistic, qualifier) - changeValue;
                    break;
                }
                case RESET: {
                    changeValue = 0;
                }
            }
            this.setStat(offlinePlayer, statistic, changeValue, qualifier);
        }
    }

    private void setStat(OfflinePlayer player, Statistic statistic, int change, Object qualifier) {
        ItemType itemType;
        Material material;
        Statistic.Type statType;
        if (change < 0) {
            change = 0;
        }
        if ((statType = statistic.getType()) == Statistic.Type.UNTYPED) {
            player.setStatistic(statistic, change);
        } else if (statType == Statistic.Type.ENTITY && qualifier instanceof EntityData) {
            EntityData entityData = (EntityData)qualifier;
            EntityType entityType = EntityUtils.toBukkitEntityType((EntityData)entityData);
            player.setStatistic(statistic, entityType, change);
        } else if (statType == Statistic.Type.BLOCK && qualifier instanceof ItemType) {
            ItemType itemType2 = (ItemType)qualifier;
            Material material2 = itemType2.getMaterial();
            if (material2.isBlock()) {
                player.setStatistic(statistic, material2, change);
            }
        } else if (statType == Statistic.Type.ITEM && qualifier instanceof ItemType && (material = (itemType = (ItemType)qualifier).getMaterial()).isItem()) {
            player.setStatistic(statistic, material, change);
        }
    }

    private int getStat(OfflinePlayer player, Statistic statistic, Object qualifier) {
        ItemType itemType;
        Material material;
        Statistic.Type statType = statistic.getType();
        if (statType == Statistic.Type.UNTYPED) {
            return player.getStatistic(statistic);
        }
        if (statType == Statistic.Type.ENTITY && qualifier instanceof EntityData) {
            EntityData entityData = (EntityData)qualifier;
            EntityType entityType = EntityUtils.toBukkitEntityType((EntityData)entityData);
            return player.getStatistic(statistic, entityType);
        }
        if (statType == Statistic.Type.BLOCK && qualifier instanceof ItemType) {
            ItemType itemType2 = (ItemType)qualifier;
            Material material2 = itemType2.getMaterial();
            if (material2.isBlock()) {
                return player.getStatistic(statistic, material2);
            }
        } else if (statType == Statistic.Type.ITEM && qualifier instanceof ItemType && (material = (itemType = (ItemType)qualifier).getMaterial()).isItem()) {
            return player.getStatistic(statistic, material);
        }
        return 0;
    }

    public boolean isSingle() {
        return this.player.isSingle();
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String qualifier = this.qualifier != null ? "using " + this.qualifier.toString(e, d) : "";
        return this.statistic.toString(e, d) + " statistic " + qualifier + " of " + this.player.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprPlayerStatistic.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"%statistic% stat[istic] [using %-entitydata/itemtype%] (of|for) %offlineplayers%"});
    }
}

