/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.structure.StructureManager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Exists")
@Description(value={"Check if a structure exists. This can be helpful to prevent overriding structures."})
@Examples(value={"if structure \"my_structures:house\" exists:", "if structure \"my_structures:town_hall\" doesn't exist:"})
@Since(value={"2.3.0"})
public class CondStructureExists
extends Condition {
    private static final StructureManager STRUCTURE_MANAGER = SkBee.getPlugin().getStructureManager();
    private Expression<String> structure;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structure = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(@NotNull Event event) {
        return this.structure.check(event, STRUCTURE_MANAGER::structureExists, this.isNegated());
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String reg = this.isNegated() ? " doesn't exist" : " exists";
        return "structure " + this.structure.toString(e, d) + reg;
    }

    static {
        Skript.registerCondition(CondStructureExists.class, (String[])new String[]{"structure %string% exists", "structure %string% (doesn't|does not) exist"});
    }
}

