/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import java.util.List;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - BlockStates")
@Description(value={"Get a list of the blockstates in a structure. This represents the palette of blocks a structure holds.", "Requires MC 1.17.1+"})
@Examples(value={"set {_list::*} to blockstates of structure {_structure}"})
@Since(value={"1.12.3"})
public class ExprStructureBlockStates
extends SimpleExpression<BlockState> {
    private Expression<StructureWrapper> structure;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.structure = exprs[0];
        return true;
    }

    @Nullable
    protected @Nullable BlockState @Nullable [] get(Event event) {
        List<BlockState> blockStates;
        StructureWrapper structure = (StructureWrapper)this.structure.getSingle(event);
        if (structure != null && (blockStates = structure.getBlockStates()) != null) {
            return blockStates.toArray(new BlockState[0]);
        }
        return null;
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends BlockState> getReturnType() {
        return BlockState.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "blockstates of structure " + this.structure.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprStructureBlockStates.class, BlockState.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"blockstates of [structure] %structure%"});
    }
}

