/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.switchcase.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.CondCompare;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SectionExpression;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionSection;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SectionSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.elements.switchcase.events.SwitchReturnEvent;
import com.shanebeestudios.skbee.elements.switchcase.events.SwitchSecEvent;
import com.shanebeestudios.skbee.elements.switchcase.sections.SecCase;
import com.shanebeestudios.skbee.elements.switchcase.sections.SecExprSwitchReturn;
import com.shanebeestudios.skbee.elements.switchcase.sections.SecSwitch;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.structure.Structure;

@Name(value="SwitchCase - Case Inline")
@Description(value={"Inline version of case section where you can return/run an effect all in one line.", "Multiple objects are supported in cases.", "- **Switch Expression** = Return an object based on the case matching the switched value.", "- **Switch Section** = Run 1 effect based on the case matching the switched value.", "Default will run if all other cases fail to match. Default must go last or all cases after it will be ignored."})
@Examples(value={"# As Effect", "on damage of a sheep by a player:", "\tswitch type of attacker's tool:", "\t\tcase wooden sword -> give attacker yellow wool", "\t\tcase stone sword -> give attacker light gray wool", "\t\tcase iron sword -> give attacker gray wool", "\t\tcase golden sword -> give attacker orange wool", "\t\tcase diamond sword -> give attacker light blue wool", "\t\tcase netherite sword -> give attacker black wool", "\t\tdefault -> give attacker white wool", "", "# As Return", "function getRoman(i: number) :: string:", "\treturn switch return {_i}:", "\t\tcase 1 -> \"I\"", "\t\tcase 2 -> \"II\"", "\t\tcase 3 -> \"III\"", "\t\tcase 4 -> \"IV\"", "\t\tcase 5 -> \"V\"", "\t\tdefault -> \"potato\"", "", "function getName(e: entity) :: string:", "\treturn switch return {_e}:", "\t\tcase sheep -> \"Mr Sheepy\"", "\t\tcase cow -> \"Mr Cow\"", "\t\tcase pig -> \"Se\u00f1or Pig\"", "\t\tdefault -> strict proper case \"%type of {_e}%\"", "", "on break:", "\tset {_b} to event-block", "\tset {_i} to switch return {_b}:", "\t\tcase stone -> 1 of stone named \"Hard Stone\"", "\t\tcase grass block -> 1 of grass block named \"Green Grass\"", "\t\tcase dirt -> 1 of dirt named \"Dry Dirt\"", "\t\tdefault -> 1 of {_b} named \"Some Other Block\"", "\tgive player {_i}", "", "on damage of a mob by a player:", "\tset {_item} to switch return type of victim:", "\t\tcase sheep, cow, pig, chicken -> 1 of potato", "\t\tcase zombie, drowned, husk -> 1 of rotten flesh", "\t\tcase skeleton, stray, wither skeleton, bogged -> 1 of bone", "\t\tdefault -> 1 of stick", "\tgive {_item} to attacker"})
@Since(value={"3.8.0"})
public class EffCase
extends Effect {
    private boolean defaultCase;
    private Expression<?> caseObject;
    private Expression<?> returnObject;
    private Effect effect;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        SecSwitch switchSection = null;
        Expression<?> switchObject = null;
        Structure structure = this.getParser().getCurrentStructure();
        if (structure instanceof SectionSkriptEvent) {
            SectionSkriptEvent skriptEvent = (SectionSkriptEvent)structure;
            Section section = skriptEvent.getSection();
            if (section instanceof SecSwitch) {
                SecSwitch secSwitch;
                switchSection = secSwitch = (SecSwitch)section;
                switchObject = secSwitch.getSwitchedObjectExpression();
            } else {
                ExpressionSection expressionSection;
                SectionExpression sectionExpression;
                section = skriptEvent.getSection();
                if (section instanceof ExpressionSection && (sectionExpression = (expressionSection = (ExpressionSection)section).getAsExpression()) instanceof SecExprSwitchReturn) {
                    SecExprSwitchReturn secExprSwitchReturn = (SecExprSwitchReturn)sectionExpression;
                    switchSection = expressionSection;
                    switchObject = secExprSwitchReturn.getSwitchedObjectExpression();
                }
            }
        }
        if (switchSection == null) {
            Skript.error((String)"Cases returns can only be used in a switch expression section.");
            return false;
        }
        String group = ((MatchResult)parseResult.regexes.getFirst()).group();
        if (switchSection instanceof SecSwitch) {
            Effect effect = Effect.parse((String)group, (String)("Cannot understand this effect: '" + group + "'"));
            if (effect == null) return false;
            this.effect = effect;
        } else {
            Expression<?> expression = SkriptUtils.parseExpression(group);
            if (expression == null) return false;
            this.returnObject = expression;
        }
        if (matchedPattern == 1) {
            this.defaultCase = true;
        } else {
            Object[] objectArray;
            this.caseObject = LiteralUtils.defendExpression(exprs[0]);
            if (switchObject != null && (objectArray = this.caseObject) instanceof Literal) {
                Literal literal = (Literal)objectArray;
                for (Object lit : literal.getArray()) {
                    Class switchReturnType = switchObject.getReturnType();
                    if (SecCase.canCompare(switchReturnType, lit.getClass())) continue;
                    Skript.error((String)("Can't compare " + CondCompare.f(switchObject) + " with " + CondCompare.f((Expression)literal)));
                    return false;
                }
            }
        }
        if (!this.defaultCase && !LiteralUtils.canInitSafely((Expression[])new Expression[]{this.caseObject})) return false;
        if (this.returnObject != null) {
            return LiteralUtils.canInitSafely((Expression[])new Expression[]{this.returnObject});
        }
        if (this.effect == null) return false;
        return true;
    }

    protected void execute(Event event) {
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (event instanceof SwitchReturnEvent) {
            Object returnObject;
            SwitchReturnEvent switchReturnEvent = (SwitchReturnEvent)event;
            if ((this.defaultCase || SecCase.compare(this.caseObject.getArray(event), switchReturnEvent.getSwitchedObject())) && (returnObject = this.returnObject.getSingle(switchReturnEvent.getParentEvent())) != null) {
                switchReturnEvent.setReturnedObject(returnObject);
                return null;
            }
        } else if (event instanceof SwitchSecEvent) {
            SwitchSecEvent switchSecEvent = (SwitchSecEvent)event;
            if ((this.defaultCase || SecCase.compare(this.caseObject.getArray(event), switchSecEvent.getSwitchedObject())) && this.effect != null) {
                TriggerItem.walk((TriggerItem)this.effect, (Event)switchSecEvent.getParentEvent());
                return null;
            }
        }
        return super.walk(event);
    }

    public String toString(Event e, boolean d) {
        String caseType = "broken";
        if (this.effect != null) {
            caseType = this.effect.toString(e, d);
        } else if (this.returnObject != null) {
            caseType = this.returnObject.toString(e, d);
        }
        if (this.defaultCase) {
            return "default -> " + caseType;
        }
        return "case " + this.caseObject.toString(e, d) + " -> " + caseType;
    }

    static {
        Skript.registerEffect(EffCase.class, (String[])new String[]{"case %objects% -> <.+>", "default -> <.+>"});
    }
}

