/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.switchcase.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SectionExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.switchcase.events.SwitchReturnEvent;
import com.shanebeestudios.skbee.elements.switchcase.events.SwitchSecEvent;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="SwitchCase - Switch Return")
@Description(value={"Switch an object and have it return a value."})
@Examples(value={"function getRoman(i: number) :: string:", "\treturn switch return {_i}:", "\t\tcase 1 -> \"I\"", "\t\tcase 2 -> \"II\"", "\t\tcase 3 -> \"III\"", "\t\tcase 4 -> \"IV\"", "\t\tcase 5 -> \"V\"", "\t\tdefault -> \"potato\"", "", "function getName(e: entity) :: string:", "\treturn switch return {_e}:", "\t\tcase sheep -> \"Mr Sheepy\"", "\t\tcase cow -> \"Mr Cow\"", "\t\tcase pig -> \"Se\u00f1or Pig\"", "\t\tdefault -> strict proper case \"%type of {_e}%\"", "", "on break:", "\tset {_i} to switch return event-block:", "\t\tcase stone -> \"Stoney Stone\"", "\t\tcase dirt -> \"Dirty Dirt\"", "\t\tcase grass block -> \"Grassy Grass\"", "\t\tdefault:", "\t\t\tif gamemode of player = creative:", "\t\t\t\treturn \"&c%type of switched object%\"", "\t\t\telse:", "\t\t\t\treturn \"&a%type of switched object%\"", "", "\tsend \"Broken: %{_i}%\" to player"})
@Since(value={"3.8.0"})
public class SecExprSwitchReturn
extends SectionExpression<Object> {
    private Expression<?> switchedObject;
    private Trigger caseSection;

    public boolean init(Expression<?>[] exprs, int pattern, Kleenean delayed, SkriptParser.ParseResult result, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        if (sectionNode == null) {
            return false;
        }
        this.switchedObject = LiteralUtils.defendExpression(exprs[0]);
        Class[] currentEvents = this.getParser().getCurrentEvents();
        Class[] events = new Class[currentEvents.length + 1];
        System.arraycopy(currentEvents, 0, events, 0, currentEvents.length);
        events[currentEvents.length] = SwitchSecEvent.class;
        this.caseSection = this.loadCode(sectionNode, "switch section expression", null, events);
        for (Node node : sectionNode) {
            String key = node.getKey();
            if (key.startsWith("case") || key.startsWith("default")) continue;
            Skript.error((String)"Only cases can be used in a switch section but found this:");
            this.caseSection = null;
            break;
        }
        return LiteralUtils.canInitSafely((Expression[])new Expression[]{this.switchedObject});
    }

    protected Object @Nullable [] get(Event event) {
        Object object = this.switchedObject.getSingle(event);
        if (object == null) {
            return null;
        }
        Object variables = Variables.copyLocalVariables((Event)event);
        SwitchReturnEvent returnEvent = new SwitchReturnEvent(object, event);
        Variables.setLocalVariables((Event)returnEvent, (Object)variables);
        Trigger.walk((TriggerItem)this.caseSection, (Event)returnEvent);
        Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)returnEvent));
        Variables.removeLocals((Event)returnEvent);
        return new Object[]{returnEvent.getReturnedObject()};
    }

    public Expression<?> getSwitchedObjectExpression() {
        return this.switchedObject;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(Event e, boolean d) {
        return "switch return " + this.switchedObject.toString(e, d);
    }

    static {
        Skript.registerExpression(SecExprSwitchReturn.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"(switch return|return switch) %object%"});
    }
}

