/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.testing.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.lang.VerboseAssert;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Condition;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@NoDoc
public class CondClassInfoRegistered
extends Condition
implements VerboseAssert {
    private Expression<String> name;
    private boolean codename;
    private String errorMessage = null;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(parseResult.hasTag("neg"));
        this.name = exprs[0];
        this.codename = parseResult.hasTag("id");
        return true;
    }

    public boolean check(Event event) {
        return this.name.check(event, name -> {
            ClassInfo ci = null;
            if (this.codename) {
                ci = Classes.getClassInfoNoError((String)name);
            } else {
                try {
                    Class<?> aClass = Class.forName(name);
                    ci = Classes.getExactClassInfo(aClass);
                }
                catch (ClassNotFoundException aClass) {
                    // empty catch block
                }
            }
            if (ci != null) {
                Parser parser = ci.getParser();
                if (parser == null) {
                    this.errorMessage = "Parser for ClassInfo '" + ci.getCodeName() + "' is null";
                    return false;
                }
                if (!parser.getClass().toString().contains("com.shanebeestudios.skbee")) {
                    this.errorMessage = "ClassInfo '" + ci.getCodeName() + "' does not belong to SkBee!";
                    return false;
                }
                return true;
            }
            this.errorMessage = "ClassInfo with name '" + name + "' is missing!";
            return false;
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return new SyntaxStringBuilder(event, debug).append((Object)"class info").append(new Object[]{this.codename ? "with codename" : "by class", this.name}).append(new Object[]{this.isNegated() ? "isn't" : "is", "registered"}).toString();
    }

    public String getExpectedMessage(Event event) {
        return "class info '" + (String)this.name.getSingle(event) + "'";
    }

    public String getReceivedMessage(Event event) {
        return this.errorMessage;
    }

    static {
        Skript.registerCondition(CondClassInfoRegistered.class, (String[])new String[]{"class info (by class|id:with codename) %string% (is|neg:isn't) registered"});
    }
}

