/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Async Chat Viewers")
@Description(value={"Represents the viewers that this chat message will be displayed to.", "NOTE: Can only be used in an `async chat event`. Requires PaperMC"})
@Examples(value={"on async chat:", "\tclear chat viewers", "\tadd player to chat viewers", "", "on async chat:", "\tset chat viewers to players in world of player", "", "on async chat:", "\tremove (all players where [input doesn't have permission \"staff.chat\"]) from chat viewers"})
@Since(value={"3.5.3"})
public class ExprAsyncChatViewers
extends SimpleExpression<CommandSender> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(AsyncChatEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in the Async Chat Event."));
            return false;
        }
        return true;
    }

    protected CommandSender @Nullable [] get(Event event) {
        if (event instanceof AsyncChatEvent) {
            AsyncChatEvent chatEvent = (AsyncChatEvent)event;
            return chatEvent.viewers().toArray(new CommandSender[0]);
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{CommandSender[].class});
            case Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(event instanceof AsyncChatEvent)) {
            return;
        }
        AsyncChatEvent chatEvent = (AsyncChatEvent)event;
        if (mode == Changer.ChangeMode.DELETE) {
            chatEvent.viewers().clear();
            return;
        }
        if (delta == null) {
            return;
        }
        ArrayList<CommandSender> viewers = new ArrayList<CommandSender>();
        for (Object object : delta) {
            if (!(object instanceof CommandSender)) continue;
            CommandSender sender = (CommandSender)object;
            viewers.add(sender);
        }
        switch (mode) {
            case ADD: {
                chatEvent.viewers().addAll(viewers);
                break;
            }
            case REMOVE: {
                viewers.forEach(chatEvent.viewers()::remove);
                break;
            }
            case SET: {
                chatEvent.viewers().clear();
                chatEvent.viewers().addAll(viewers);
            }
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends CommandSender> getReturnType() {
        return CommandSender.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "async chat viewers";
    }

    static {
        Skript.registerExpression(ExprAsyncChatViewers.class, CommandSender.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[async] chat viewers"});
    }
}

