/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.event.HoverEvent;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Name(value="TextComponent - Hover Event")
@Description(value={"Create a new hover event. Can show texts, text components, an item or an entity to a player.", "'showing %itemtype%' requires Minecraft 1.18.2+"})
@Examples(value={"set {_t} to text component from \"Check out my cool tool!\"", "add hover event showing player's tool to {_t}", "send component {_t} to player"})
@Since(value={"1.5.0"})
public class ExprHoverEvent
extends SimpleExpression<HoverEvent> {
    private static final boolean HAS_SHOW_ENITY = Skript.methodExists(HoverEvent.ShowEntity.class, (String)"showEntity", (Class[])new Class[]{Key.class, UUID.class});
    private Expression<?> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.object = exprs[0];
        return true;
    }

    @Nullable
    protected HoverEvent[] get(Event event) {
        Object key;
        Object object;
        if (this.object.isSingle() && (object = this.object.getSingle(event)) instanceof Entity) {
            Entity entity = (Entity)object;
            key = entity.getType().key();
            UUID uuid = entity.getUniqueId();
            HoverEvent.ShowEntity showEntity = HAS_SHOW_ENITY ? HoverEvent.ShowEntity.showEntity((Key)key, (UUID)uuid) : HoverEvent.ShowEntity.of((Key)key, (UUID)uuid);
            return new HoverEvent[]{HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_ENTITY, (Object)showEntity)};
        }
        if (this.object.isSingle() && (key = this.object.getSingle(event)) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)key;
            if (itemStack.getType().isAir() || !itemStack.getType().isItem()) {
                itemStack = new ItemStack(Material.STONE);
            }
            return new HoverEvent[]{itemStack.asHoverEvent()};
        }
        ArrayList<ComponentWrapper> components = new ArrayList<ComponentWrapper>();
        for (Object object2 : this.object.getArray(event)) {
            if (object2 instanceof String) {
                String string = (String)object2;
                components.add(ComponentWrapper.fromText(string));
                continue;
            }
            if (!(object2 instanceof ComponentWrapper)) continue;
            ComponentWrapper component = (ComponentWrapper)object2;
            components.add(component);
        }
        ComponentWrapper newLine = ComponentWrapper.fromText("\n");
        ComponentWrapper hover = ComponentWrapper.fromComponents(components.toArray(new ComponentWrapper[0]), newLine);
        return new HoverEvent[]{HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)hover.getComponent())};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends HoverEvent> getReturnType() {
        return HoverEvent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "hover event showing " + this.object.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprHoverEvent.class, HoverEvent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] hover event showing %strings/textcomponents/itemstacks/entities%"});
    }
}

