/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Item Lore Lines")
@Description(value={"Get/set/delete specific lines of lore of an item using text components."})
@Examples(value={"set {_lore} to line 3 of component lore of {_item}", "set line 1 of component lore of player's tool to mini message from \"Look Mah, I'm in Minecraft!\"", "delete line 6 of component lore of player's tool"})
@Since(value={"3.9.0"})
public class ExprItemLoreLine
extends SimpleExpression<ComponentWrapper> {
    private Expression<Integer> line;
    private Expression<?> item;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = exprs[matchedPattern];
        this.item = LiteralUtils.defendExpression(exprs[matchedPattern ^ 1]);
        return true;
    }

    protected ComponentWrapper @Nullable [] get(Event event) {
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(this.item.getSingle(event));
        Integer line = (Integer)this.line.getSingle(event);
        if (itemStack == null || line == null) {
            return null;
        }
        List lore = itemStack.lore();
        line = line - 1;
        if (lore != null && lore.size() > line && line >= 0) {
            return new ComponentWrapper[]{ComponentWrapper.fromComponent((Component)lore.get(line))};
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        Integer l = (Integer)this.line.getSingle(event);
        if (l == null) {
            return;
        }
        int line = l - 1;
        ItemUtils.modifyItems(this.item.getSingle(event), itemStack -> {
            List<Component> lore = itemStack.lore();
            if (lore == null) {
                lore = Collections.emptyList();
            }
            if (mode == Changer.ChangeMode.DELETE) {
                ArrayList<Component> newLore = new ArrayList<Component>();
                for (int i = 0; i < lore.size(); ++i) {
                    if (i == line) continue;
                    newLore.add((Component)lore.get(i));
                }
                itemStack.lore(newLore);
            } else {
                TextComponent textComponent;
                Object patt0$temp;
                Component[] loreArray = lore.toArray(new Component[Math.max(lore.size(), line + 1)]);
                if (delta != null && (patt0$temp = delta[0]) instanceof ComponentWrapper) {
                    ComponentWrapper cw = (ComponentWrapper)patt0$temp;
                    textComponent = cw.getComponent();
                } else {
                    textComponent = Component.empty();
                }
                loreArray[line] = textComponent;
                for (int i = 0; i < loreArray.length; ++i) {
                    if (loreArray[i] != null) continue;
                    loreArray[i] = Component.empty();
                }
                itemStack.lore(Arrays.asList(loreArray));
            }
        });
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return new SyntaxStringBuilder(e, d).append(new Object[]{"line", this.line}).append(new Object[]{"of component item lore of", this.item}).toString();
    }

    static {
        Skript.registerExpression(ExprItemLoreLine.class, ComponentWrapper.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"line %integer% of [the] component [item] lore of %itemstack/itemtype/slot%", "%itemstack/itemtype/slot%'[s] line %integer% of component [item] lore"});
    }
}

