/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Inventory Name")
@Description(value={"Get/set the name of an inventory using components.", "NOTE: This will only rename OPEN inventories, not inventories saved in variables.", "NOTE: Internally the component is stringified, so things like fonts wont work.", "Requires Minecraft 1.21+", "For versions below 1.21, just use Skript's inventory title expression."})
@Examples(value={"set component inventory title of player's current inventory to {_t}"})
@Since(value={"2.4.0"})
public class ExprNameInventory
extends SimplePropertyExpression<Inventory, ComponentWrapper> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Util.IS_RUNNING_MC_1_21) {
            Skript.error((String)"'component inventory name' requires Minecraft 1.21+");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public ComponentWrapper convert(Inventory inventory) {
        List viewers = inventory.getViewers();
        if (!viewers.isEmpty()) {
            Component title = ((HumanEntity)viewers.get(0)).getOpenInventory().title();
            return ComponentWrapper.fromComponent(title);
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Inventory[] inventoryArray;
        if (mode == Changer.ChangeMode.SET && (inventoryArray = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper component = (ComponentWrapper)inventoryArray;
            for (Inventory inventory : (Inventory[])this.getExpr().getArray(event)) {
                component.setInventoryName(inventory);
            }
        }
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "component inventory name";
    }

    static {
        ExprNameInventory.register(ExprNameInventory.class, ComponentWrapper.class, (String)"component inventory (name|title)", (String)"inventories");
    }
}

