/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.tickmanager.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Name(value="Server Tick - Is Entity Frozen")
@Description(value={"Checks if a given entity is frozen.", "Entities will only be frozen if 3 criteria are met:", "\n - Server is frozen (via `/tick freeze` command or frozen state expression).", "\n - Entity is not a player.", "\n - Entity has no player passengers.", "\nI understand the syntax is a bit silly but it's to prevent collission with Skript's `%entity% is frozen` condition.", "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.", "Requires Minecraft 1.20.4+"})
@Examples(value={"if target entity is tick frozen:", "if loop-entity is tick frozen:", "if all entities are tick frozen:"})
@Since(value={"3.1.0"})
public class CondServerTickEntityFrozen
extends PropertyCondition<Entity> {
    public boolean check(Entity entity) {
        return Bukkit.getServerTickManager().isFrozen(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "tick frozen";
    }

    static {
        CondServerTickEntityFrozen.register(CondServerTickEntityFrozen.class, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.BE, (String)"tick frozen", (String)"entities");
    }
}

