/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Merchant Recipe - Ingredients")
@Description(value={"Represents the ingredients/result of a merchant recipe.", "Ingredients can be set, but the result can not be changed.", "If you wish to change the result, you will have to create a new merchant recipe."})
@Examples(value={"set {_ing::*} to ingredients of merchant recipe {_recipe}", "set ingredients of merchant recipe {_recipe} to diamond and stone", "set {_result} to result item of merchant recipe {_recipe}"})
@Since(value={"1.17.0"})
public class ExprMerchantRecipeIngredients
extends SimpleExpression<ItemType> {
    private int pattern;
    private Expression<MerchantRecipe> recipe;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.recipe = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        MerchantRecipe recipe = (MerchantRecipe)this.recipe.getSingle(event);
        if (recipe == null) {
            return null;
        }
        if (this.pattern == 0) {
            ArrayList items = new ArrayList();
            recipe.getIngredients().forEach(itemStack -> items.add(new ItemType(itemStack)));
            return items.toArray(new ItemType[0]);
        }
        ItemStack result = recipe.getResult();
        ItemType itemType = new ItemType(result);
        return new ItemType[]{itemType};
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && this.pattern == 0) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType[].class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        MerchantRecipe recipe = (MerchantRecipe)this.recipe.getSingle(event);
        if (recipe == null || mode != Changer.ChangeMode.SET) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Object object : delta) {
            if (!(object instanceof ItemType)) continue;
            ItemType itemType = (ItemType)object;
            if (stacks.size() > 1) continue;
            stacks.add(itemType.getRandom());
        }
        recipe.setIngredients(stacks);
    }

    public boolean isSingle() {
        return this.pattern == 1;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "ingredients of merchant recipe " + this.recipe.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprMerchantRecipeIngredients.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"(ingredients|1:result [item]) of merchant recipe %merchantrecipe%"});
    }
}

