/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Machine Name")
@Description(value={"Get/set the name of a virtual furnace."})
@Examples(value={"set {_name} to machine name of {_furnace}", "set machine name of {_furnace} to \"Super Fast Furnace\""})
@Since(value={"3.3.0"})
public class ExprVirtualFurnaceMachineName
extends SimplePropertyExpression<Machine, String> {
    @Nullable
    public String convert(Machine machine) {
        return machine.getName();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Machine[] machineArray;
        if (mode == Changer.ChangeMode.SET && delta != null && (machineArray = delta[0]) instanceof String) {
            String string = (String)machineArray;
            for (Machine machine : (Machine[])this.getExpr().getArray(event)) {
                machine.setName(string);
            }
        }
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "machine name";
    }

    static {
        ExprVirtualFurnaceMachineName.register(ExprVirtualFurnaceMachineName.class, String.class, (String)"[virtual] (machine|furnace) name", (String)"machines");
    }
}

