/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.FurnaceProperties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.Properties;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Default Furnace Properties")
@Description(value={"Represents furnace properties that mimic vanilla Minecraft properties."})
@Examples(value={"set {_prop} to default furnace properties", "set {_furnace} to virtual furnace named \"Potato\" with properties {_prop}"})
@Since(value={"3.3.0"})
public class ExprVirtualFurnacePropertiesDefault
extends SimpleExpression<Properties> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        return true;
    }

    @Nullable
    protected Properties[] get(Event event) {
        FurnaceProperties properties = switch (this.pattern) {
            case 1 -> FurnaceProperties.BLAST_FURNACE;
            case 2 -> FurnaceProperties.SMOKER;
            default -> FurnaceProperties.FURNACE;
        };
        return new Properties[]{properties};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Properties> getReturnType() {
        return Properties.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String properties = switch (this.pattern) {
            case 1 -> "blast furnace";
            case 2 -> "smoker";
            default -> "furnace";
        };
        return "default " + properties + " properties";
    }

    static {
        Skript.registerExpression(ExprVirtualFurnacePropertiesDefault.class, Properties.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"default (furnace|1:blast furnace|2:smoker) properties"});
    }
}

