/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.type;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.yggdrasil.Fields;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.api.virtualfurnace.api.FurnaceManager;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.Properties;
import java.io.StreamCorruptedException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Types {
    public static final FurnaceManager FURNACE_MANAGER = SkBee.getPlugin().getVirtualFurnaceAPI().getFurnaceManager();

    static {
        Classes.registerClass((ClassInfo)new ClassInfo(Machine.class, "machine").user(new String[]{"machines?"}).name("VirtualFurnace - Machine").description(new String[]{"Represents a virtual machine. These machines tick on their own like a regular", "vanilla Minecraft furnace except they can be loaded from anywhere and don't rely on chunks."}).since("3.3.0").parser(SkriptUtils.getDefaultParser()).changer((Changer)new Changer<Machine>(){

            @Nullable
            public Class<?>[] acceptChange(@NotNull Changer.ChangeMode changeMode) {
                if (changeMode == Changer.ChangeMode.DELETE) {
                    return (Class[])CollectionUtils.array((Object[])new Class[0]);
                }
                return null;
            }

            public void change(Machine[] machines, @Nullable Object[] objects, Changer.ChangeMode changeMode) {
                if (changeMode != Changer.ChangeMode.DELETE) {
                    return;
                }
                for (Machine machine : machines) {
                    FURNACE_MANAGER.removeMachine(machine, false);
                }
                FURNACE_MANAGER.saveConfig();
            }
        }).serializer((Serializer)new Serializer<Machine>(){

            @NotNull
            public Fields serialize(Machine machine) {
                Fields fields = new Fields();
                if (machine instanceof Furnace) {
                    Furnace furnace = (Furnace)machine;
                    fields.putObject("type", (Object)"furnace");
                }
                fields.putObject("id", (Object)machine.getUniqueID().toString());
                return fields;
            }

            public void deserialize(Machine o, Fields f) {
            }

            protected Machine deserialize(Fields fields) throws StreamCorruptedException {
                String type = (String)fields.getObject("type", String.class);
                assert (type != null);
                if (type.equals("furnace")) {
                    String uuid = (String)fields.getObject("id", String.class);
                    assert (uuid != null);
                    Machine machine = FURNACE_MANAGER.getByID(UUID.fromString(uuid));
                    if (machine != null) {
                        return machine;
                    }
                    throw new StreamCorruptedException("Invalid machine with id: " + uuid);
                }
                throw new StreamCorruptedException("Invalid machine type: " + type);
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(Properties.class, "machineproperty").user(new String[]{"machine ?propert(y|ies)"}).name("VirtualFurnace - Machine Properties").description(new String[]{"Represents the machine properties of a virtual machine."}).since("3.3.0").parser(SkriptUtils.getDefaultParser()));
    }
}

