/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Stats")
@Description(value={"Get/set different stats of a world border.", "\ndamage amount = amount of damage a player takes when outside the border plus the border buffer.", "\ndamage buffer = amount of blocks a player may safely be outside the border before taking damage.", "\nsize = border to a square region with the specified side length in blocks.", "\nwarning distance = distance that causes the screen to be tinted red when the player is within the specified number of blocks from the border."})
@Examples(value={"set damage amount of world border of world of player to 10", "set size of world border of player to 100"})
@Since(value={"1.17.0"})
public class ExprWorldBorderNumbers
extends SimplePropertyExpression<WorldBorder, Number> {
    private int pattern;
    private static final String[] PATTERNS;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.setExpr(exprs[0]);
        return true;
    }

    @Nullable
    public Number convert(WorldBorder worldBorder) {
        return switch (this.pattern) {
            case 1 -> worldBorder.getDamageBuffer();
            case 2 -> worldBorder.getSize();
            case 3 -> worldBorder.getWarningDistance();
            default -> worldBorder.getDamageAmount();
        };
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Number number = (Number)delta[0];
        if (number == null) {
            return;
        }
        block5: for (WorldBorder border : (WorldBorder[])this.getExpr().getArray(event)) {
            switch (this.pattern) {
                case 1: {
                    border.setDamageBuffer(number.doubleValue());
                    continue block5;
                }
                case 2: {
                    border.setSize(number.doubleValue());
                    continue block5;
                }
                case 3: {
                    border.setWarningDistance(number.intValue());
                    continue block5;
                }
                default: {
                    border.setDamageAmount(number.doubleValue());
                }
            }
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return PATTERNS[this.pattern];
    }

    static {
        ExprWorldBorderNumbers.register(ExprWorldBorderNumbers.class, Number.class, (String)"[border] (damage amount|1:damage buffer|2:size|3:warning distance)", (String)"worldborders");
        PATTERNS = new String[]{"damage amount", "damage buffer", "size", "warning distance"};
    }
}

