/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.type;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.jetbrains.annotations.Nullable;

public class Types {
    private static final Changer<WorldBorder> BORDER_CHANGER = new Changer<WorldBorder>(){

        @Nullable
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{WorldBorder.class});
            }
            return null;
        }

        public void change(WorldBorder[] worldBorders, @Nullable Object[] objects, Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                for (WorldBorder worldBorder : worldBorders) {
                    worldBorder.reset();
                }
            }
        }
    };

    static {
        if (Classes.getExactClassInfo(WorldBorder.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(WorldBorder.class, "worldborder").user(new String[]{"world ?borders?"}).name("World Border").description(new String[]{"Represents the world border of a world/player.", "World borders can be reset.", "(This will need to be done from a var since the expression handles it differently)"}).examples(new String[]{"set {_w} to world border of player", "reset {_w}"}).since("1.17.0").parser((Parser)new Parser<WorldBorder>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                public String toString(WorldBorder worldBorder, int i) {
                    World world = worldBorder.getWorld();
                    if (world != null) {
                        String worldName = Classes.toString((Object)world);
                        return "world border of world '" + worldName + "'";
                    }
                    Object borderString = worldBorder.toString();
                    borderString = ((String)borderString).contains("@") ? " @" + ((String)borderString).split("@")[1] : "";
                    return "virtual world border" + (String)borderString;
                }

                public String toVariableNameString(WorldBorder worldBorder) {
                    return "worldborder: " + this.toString(worldBorder, 0);
                }
            }).changer(BORDER_CHANGER));
        } else {
            Util.logLoading("It looks like another addon registered 'worldborder' already.", new Object[0]);
            Util.logLoading("You may have to use their worldborder in SkBee's 'WorldBorder elements.", new Object[0]);
        }
    }
}

