/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="World Exists")
@Description(value={"Check if a world exists in your world directory."})
@Examples(value={"if world file \"my-world\" exists:"})
@Since(value={"1.8.0"})
public class CondWorldExists
extends Condition {
    private Expression<String> world;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.world = exprs[0];
        this.setNegated(parseResult.mark == 1);
        return true;
    }

    public boolean check(@NotNull Event e) {
        return this.world.check(e, this::isAWorld, this.isNegated());
    }

    private boolean isAWorld(String worldName) {
        File worldFile = new File(Bukkit.getWorldContainer(), worldName);
        if (worldFile.exists() && worldFile.isDirectory()) {
            File levelDat = new File(worldFile, "level.dat");
            return levelDat.exists();
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return String.format("world file %s %s", this.world.toString(e, d), this.isNegated() ? "does not exist" : "exists");
    }

    static {
        Skript.registerCondition(CondWorldExists.class, (String[])new String[]{"world file %string% (exists|1:(does not|doesn't) exist)"});
    }
}

