/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Loaded Custom Worlds")
@Description(value={"Represents all loaded custom worlds created using SkBee.", "This will not include worlds created by other plugins, such as MultiVerse."})
@Examples(value={"loop all loaded custom worlds:"})
@Since(value={"3.5.3"})
public class ExprLoadedCustomWorlds
extends SimpleExpression<World> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected World[] get(Event event) {
        return SkBee.getPlugin().getBeeWorldConfig().getLoadedCustomWorlds().toArray(new World[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends World> getReturnType() {
        return World.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "all loaded custom worlds";
    }

    static {
        Skript.registerExpression(ExprLoadedCustomWorlds.class, World.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[all] loaded (custom|skbee) worlds"});
    }
}

