/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.objects;

import ch.njol.skript.test.runner.TestMode;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class BeeWorldConfig {
    private final SkBee plugin;
    private FileConfiguration worldConfig;
    private File worldConfigFile;
    private final boolean autoLoadWorlds;
    private final Map<String, BeeWorldCreator> WORLDS = new HashMap<String, BeeWorldCreator>();

    public BeeWorldConfig(SkBee plugin) {
        this.plugin = plugin;
        this.autoLoadWorlds = plugin.getPluginConfig().AUTO_LOAD_WORLDS;
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.worldConfigFile == null) {
            this.worldConfigFile = new File(this.plugin.getDataFolder(), "worlds.yml");
        }
        if (!this.worldConfigFile.exists()) {
            this.plugin.saveResource("worlds.yml", false);
        }
        this.worldConfig = YamlConfiguration.loadConfiguration((File)this.worldConfigFile);
    }

    public void loadCustomWorlds() {
        ConfigurationSection section = this.worldConfig.getConfigurationSection("worlds");
        if (section != null) {
            Set keys = section.getKeys(false);
            if (keys.isEmpty()) {
                return;
            }
            Util.log("&6Loading custom worlds...", new Object[0]);
            int loadedWorlds = 0;
            for (String key : keys) {
                BeeWorldCreator beeWorldCreator = this.loadWorld(key);
                if (beeWorldCreator == null) continue;
                this.WORLDS.put(key, beeWorldCreator);
                if (!beeWorldCreator.isLoaded) continue;
                ++loadedWorlds;
            }
            Util.log("&aSuccessfully loaded &b%s &acustom world%s", loadedWorlds, loadedWorlds == 1 ? "" : "s");
        }
    }

    @Nullable
    public BeeWorldCreator loadWorld(String name) {
        String environment;
        String path = "worlds." + name + ".";
        String keyString = this.worldConfig.getString(path + "key");
        NamespacedKey key = keyString != null ? Util.getNamespacedKey(keyString, false) : null;
        BeeWorldCreator worldCreator = new BeeWorldCreator(name, key);
        String type = this.worldConfig.getString(path + "type");
        if (type != null) {
            worldCreator.setWorldType(this.getWorldType(type));
        }
        if ((environment = this.worldConfig.getString(path + "environment")) != null) {
            worldCreator.setEnvironment(this.getEnvironment(environment));
        }
        if (this.worldConfig.isSet(path + "seed")) {
            long seed = this.worldConfig.getLong(path + "seed");
            worldCreator.setSeed(seed);
        }
        if (this.worldConfig.isSet(path + "generator-settings")) {
            worldCreator.setGeneratorSettings(this.worldConfig.getString(path + "generator-settings"));
        }
        if (this.worldConfig.isSet(path + "generator")) {
            worldCreator.setGenerator(this.worldConfig.getString(path + "generator"));
        }
        if (this.worldConfig.isSet(path + "structures")) {
            worldCreator.setGenStructures(this.worldConfig.getBoolean(path + "structures"));
        }
        if (this.worldConfig.isSet(path + "hardcore")) {
            worldCreator.setHardcore(this.worldConfig.getBoolean(path + "hardcore"));
        }
        if (this.worldConfig.isSet(path + "keep-spawn-loaded")) {
            worldCreator.setKeepSpawnLoaded(this.worldConfig.getBoolean(path + "keep-spawn-loaded"));
        }
        if (this.worldConfig.isSet(path + "load-on-start")) {
            boolean loadOnStart = this.worldConfig.getBoolean(path + "load-on-start");
            worldCreator.setLoadOnStart(loadOnStart);
            if (!loadOnStart) {
                return worldCreator;
            }
        } else if (!this.autoLoadWorlds) {
            return worldCreator;
        }
        if (worldCreator.loadWorld() != null) {
            worldCreator.isLoaded = true;
            return worldCreator;
        }
        return null;
    }

    public void saveWorldToFile(BeeWorldCreator worldCreator) {
        if (!this.WORLDS.containsKey(worldCreator.getWorldName())) {
            this.WORLDS.put(worldCreator.getWorldName(), worldCreator);
        }
        String path = "worlds." + worldCreator.getWorldName() + ".";
        this.worldConfig.set(path + "key", (Object)worldCreator.getKey().toString());
        this.worldConfig.set(path + "type", (Object)worldCreator.getWorldType().toString());
        this.worldConfig.set(path + "environment", (Object)worldCreator.getEnvironment().toString());
        this.worldConfig.set(path + "seed", (Object)worldCreator.seed);
        if (worldCreator.getGeneratorSettings() != null) {
            this.worldConfig.set(path + "generator-settings", (Object)worldCreator.getGeneratorSettings());
        }
        if (worldCreator.getGenerator() != null) {
            this.worldConfig.set(path + "generator", (Object)worldCreator.getGenerator());
        }
        worldCreator.genStructures.ifPresent(aBoolean -> this.worldConfig.set(path + "structures", aBoolean));
        worldCreator.hardcore.ifPresent(aBoolean -> this.worldConfig.set(path + "hardcore", aBoolean));
        worldCreator.keepSpawnLoaded.ifPresent(aBoolean -> this.worldConfig.set(path + "keep-spawn-loaded", aBoolean));
        worldCreator.loadOnStart.ifPresent(aBoolean -> this.worldConfig.set(path + "load-on-start", aBoolean));
        this.save();
    }

    public void deleteWorld(String worldName) {
        if (this.WORLDS.containsKey(worldName) && !worldName.equalsIgnoreCase("plugins")) {
            this.WORLDS.remove(worldName);
            this.worldConfig.set("worlds." + worldName, null);
            this.save();
            File worldFile = new File(Bukkit.getWorldContainer(), worldName);
            if (worldFile.exists() && worldFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)worldFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void save() {
        if (TestMode.ENABLED) {
            return;
        }
        try {
            this.worldConfig.save(this.worldConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private WorldType getWorldType(String name) {
        try {
            return WorldType.valueOf((String)name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ignore) {
            Util.skriptError("Invalid world type: " + name.toUpperCase(Locale.ROOT), new Object[0]);
            Util.skriptError(" - &7Default to NORMAL", new Object[0]);
            return WorldType.NORMAL;
        }
    }

    private World.Environment getEnvironment(String name) {
        try {
            return World.Environment.valueOf((String)name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ignore) {
            Util.skriptError("Invalid world environment: " + name.toUpperCase(Locale.ROOT), new Object[0]);
            Util.skriptError(" - &7Default to NORMAL", new Object[0]);
            return World.Environment.NORMAL;
        }
    }

    public List<World> getLoadedCustomWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        this.WORLDS.forEach((string, beeWorldCreator) -> {
            World world = Bukkit.getWorld((String)beeWorldCreator.getWorldName());
            if (world != null) {
                worlds.add(world);
            }
        });
        return worlds;
    }
}

